/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.RevisionFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import java.util.Calendar;
import java.util.Date;

public class RevisionType
extends Type
implements RevisionFeature {
    private Calendar revision = null;

    public RevisionType() {
        this((Calendar)null);
    }

    public RevisionType(Date revision) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setRevision(revision);
    }

    public RevisionType(Calendar revision) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setRevision(revision);
    }

    @Override
    public Calendar getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(Calendar revisionDate) {
        this.revision = revisionDate;
    }

    @Override
    public void setRevision(Date date) {
        this.revision.setTime(date);
    }

    @Override
    public void clearRevision() {
        this.revision = null;
    }

    @Override
    public boolean hasRevision() {
        return this.revision != null;
    }

    @Override
    public String getTypeString() {
        return VCardType.REV.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof RevisionType) {
                return this == obj || ((RevisionType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.revision != null) {
            sb.append(this.revision.getTime().toString());
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public RevisionFeature clone() {
        RevisionType cloned = new RevisionType();
        if (this.revision != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(this.revision.getTimeInMillis());
            cloned.setRevision(cal);
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

