/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.SortStringFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;

public class SortStringType
extends Type
implements SortStringFeature {
    private String sortString = null;

    public SortStringType() {
        this((String)null);
    }

    public SortStringType(String sortString) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setSortString(sortString);
    }

    @Override
    public String getSortString() {
        return this.sortString;
    }

    @Override
    public void setSortString(String sortString) {
        this.sortString = sortString;
    }

    @Override
    public void clearSortString() {
        this.sortString = null;
    }

    @Override
    public boolean hasSortString() {
        return this.sortString != null;
    }

    @Override
    public String getTypeString() {
        return VCardType.SORT_STRING.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof SortStringType) {
                return this == obj || ((SortStringType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.sortString != null) {
            sb.append(this.sortString);
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public SortStringFeature clone() {
        SortStringType cloned = new SortStringType();
        if (this.sortString != null) {
            cloned.setSortString(this.sortString);
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

