/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.StringUtil;
import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.SoundFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.media.AudioMediaType;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import info.ineighborhood.cardme.vcard.types.parameters.SoundParameterType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;

public class SoundType
extends Type
implements SoundFeature {
    private byte[] soundBytes = null;
    private URI soundUri = null;
    private SoundParameterType soundParameterType = null;
    private AudioMediaType audioMediaType = null;
    private boolean isSetCompression = false;

    public SoundType() {
    }

    public SoundType(URI soundUri, EncodingType encodingType, SoundParameterType soundParameterType) {
        super(encodingType, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setSoundURI(soundUri);
        this.setSoundParameterType(soundParameterType);
    }

    public SoundType(byte[] soundBytes, EncodingType encodingType, SoundParameterType soundParameterType) {
        super(encodingType, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setSound(soundBytes);
        this.setSoundParameterType(soundParameterType);
    }

    @Override
    public byte[] getSound() {
        return this.soundBytes;
    }

    @Override
    public URI getSoundURI() {
        return this.soundUri;
    }

    @Override
    public boolean hasSound() {
        return this.soundBytes != null || this.soundUri != null;
    }

    @Override
    public boolean isURI() {
        return this.soundUri != null;
    }

    @Override
    public boolean isInline() {
        return this.soundBytes != null;
    }

    @Override
    public SoundParameterType getSoundParameterType() {
        return this.soundParameterType;
    }

    @Override
    public AudioMediaType getAudioMediaType() {
        return this.audioMediaType;
    }

    @Override
    public void setSoundParameterType(SoundParameterType soundParameterType) {
        this.soundParameterType = soundParameterType;
    }

    @Override
    public void setAudioMediaType(AudioMediaType audioMediaType) {
        this.audioMediaType = audioMediaType;
    }

    @Override
    public void setSound(byte[] soundBytes) {
        this.soundBytes = soundBytes;
    }

    @Override
    public void setSoundURI(URI soundUri) {
        this.soundUri = soundUri;
    }

    @Override
    public boolean hasSoundParameterType() {
        return this.soundParameterType != null;
    }

    @Override
    public boolean hasAudioMediaType() {
        return this.audioMediaType != null;
    }

    @Override
    public void setCompression(boolean compression) {
        this.isSetCompression = compression;
    }

    @Override
    public boolean isSetCompression() {
        return this.isSetCompression;
    }

    @Override
    public String getTypeString() {
        return VCardType.SOUND.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof SoundType) {
                return this == obj || ((SoundType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.soundBytes != null) {
            sb.append(StringUtil.toHexString(this.soundBytes));
            sb.append(",");
        }
        if (this.soundUri != null) {
            sb.append(this.soundUri.getPath());
            sb.append(",");
        }
        if (this.soundParameterType != null) {
            sb.append(this.soundParameterType.getType());
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public SoundFeature clone() {
        SoundType cloned = new SoundType();
        if (this.soundBytes != null) {
            byte[] clonedBytes = Arrays.copyOf(this.soundBytes, this.soundBytes.length);
            cloned.setSound(clonedBytes);
        }
        if (this.soundUri != null) {
            try {
                cloned.setSoundURI(new URI(this.soundUri.getPath()));
            }
            catch (URISyntaxException e) {
                cloned.setSoundURI(null);
            }
        }
        if (this.soundParameterType != null) {
            cloned.setSoundParameterType(this.soundParameterType);
        }
        if (this.audioMediaType != null) {
            cloned.setAudioMediaType(this.audioMediaType);
        }
        cloned.setCompression(this.isSetCompression);
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

