/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.TelephoneFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import info.ineighborhood.cardme.vcard.types.parameters.TelephoneParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.XTelephoneParameterType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TelephoneType
extends Type
implements TelephoneFeature {
    private String telephone = null;
    private List<TelephoneParameterType> telephoneParameterTypes = null;
    private List<XTelephoneParameterType> xtendedTelephoneParameterTypes = null;

    public TelephoneType() {
        this((String)null);
    }

    public TelephoneType(String telephone) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setTelephone(telephone);
        this.telephoneParameterTypes = new ArrayList<TelephoneParameterType>();
        this.xtendedTelephoneParameterTypes = new ArrayList<XTelephoneParameterType>();
    }

    @Override
    public String getTelephone() {
        return this.telephone;
    }

    @Override
    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    @Override
    public Iterator<TelephoneParameterType> getTelephoneParameterTypes() {
        return this.telephoneParameterTypes.listIterator();
    }

    @Override
    public List<TelephoneParameterType> getTelephoneParameterTypesList() {
        return Collections.unmodifiableList(this.telephoneParameterTypes);
    }

    @Override
    public int getTelephoneParameterSize() {
        return this.telephoneParameterTypes.size();
    }

    @Override
    public void addTelephoneParameterType(TelephoneParameterType telephoneParameterType) {
        this.telephoneParameterTypes.add(telephoneParameterType);
    }

    @Override
    public void removeTelephoneParameterType(TelephoneParameterType telephoneParameterType) {
        this.telephoneParameterTypes.remove((Object)telephoneParameterType);
    }

    @Override
    public boolean containsTelephoneParameterType(TelephoneParameterType telephoneParameterType) {
        return this.telephoneParameterTypes.contains((Object)telephoneParameterType);
    }

    @Override
    public boolean hasTelephoneParameterTypes() {
        return !this.telephoneParameterTypes.isEmpty();
    }

    @Override
    public void clearTelephoneParameterTypes() {
        this.telephoneParameterTypes.clear();
    }

    @Override
    public Iterator<XTelephoneParameterType> getExtendedTelephoneParameterTypes() {
        return this.xtendedTelephoneParameterTypes.listIterator();
    }

    @Override
    public List<XTelephoneParameterType> getExtendedTelephoneParameterTypesList() {
        return Collections.unmodifiableList(this.xtendedTelephoneParameterTypes);
    }

    @Override
    public int getExtendedTelephoneParameterSize() {
        return this.xtendedTelephoneParameterTypes.size();
    }

    @Override
    public void addExtendedTelephoneParameterType(XTelephoneParameterType xtendedTelephoneParameterType) {
        this.xtendedTelephoneParameterTypes.add(xtendedTelephoneParameterType);
    }

    @Override
    public void removeExtendedTelephoneParameterType(XTelephoneParameterType xtendedTelephoneParameterType) {
        this.xtendedTelephoneParameterTypes.remove(xtendedTelephoneParameterType);
    }

    @Override
    public boolean containsExtendedTelephoneParameterType(XTelephoneParameterType xtendedTelephoneParameterType) {
        return this.xtendedTelephoneParameterTypes.contains(xtendedTelephoneParameterType);
    }

    @Override
    public boolean hasExtendedTelephoneParameterTypes() {
        return !this.xtendedTelephoneParameterTypes.isEmpty();
    }

    @Override
    public void clearExtendedTelephoneParameterTypes() {
        this.xtendedTelephoneParameterTypes.clear();
    }

    @Override
    public boolean hasTelephone() {
        return this.telephone != null;
    }

    @Override
    public String getTypeString() {
        return VCardType.TEL.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof TelephoneType) {
                return this == obj || ((TelephoneType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.telephone != null) {
            sb.append(this.telephone);
            sb.append(",");
        }
        if (!this.telephoneParameterTypes.isEmpty()) {
            for (i = 0; i < this.telephoneParameterTypes.size(); ++i) {
                sb.append(this.telephoneParameterTypes.get(i).getType());
                sb.append(",");
            }
        }
        if (!this.xtendedTelephoneParameterTypes.isEmpty()) {
            for (i = 0; i < this.xtendedTelephoneParameterTypes.size(); ++i) {
                sb.append(this.xtendedTelephoneParameterTypes.get(i).getType());
                sb.append(",");
            }
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public TelephoneFeature clone() {
        TelephoneType cloned = new TelephoneType();
        if (this.telephone != null) {
            cloned.setTelephone(this.telephone);
        }
        if (!this.telephoneParameterTypes.isEmpty()) {
            for (TelephoneParameterType telephoneParameterType : this.telephoneParameterTypes) {
                cloned.addTelephoneParameterType(telephoneParameterType);
            }
        }
        if (!this.xtendedTelephoneParameterTypes.isEmpty()) {
            for (XTelephoneParameterType xtendedTelephoneParameterType : this.xtendedTelephoneParameterTypes) {
                cloned.addExtendedTelephoneParameterType(xtendedTelephoneParameterType);
            }
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

