/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.ISOFormat;
import info.ineighborhood.cardme.util.ISOUtils;
import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.TimeZoneFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import info.ineighborhood.cardme.vcard.types.parameters.TimeZoneParameterType;
import java.util.TimeZone;

public class TimeZoneType
extends Type
implements TimeZoneFeature {
    private TimeZone timeZone = null;
    private int hourOffset = 0;
    private int minuteOffset = 0;
    private String textValue = null;
    private TimeZoneParameterType timeZoneParameterType = null;

    public TimeZoneType() {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
    }

    public TimeZoneType(TimeZone timeZone) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setTimeZone(timeZone);
    }

    public TimeZoneType(int hourOffset, int minuteOffset) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setHourOffset(hourOffset);
        this.setMinuteOffset(minuteOffset);
    }

    public TimeZoneType(String textValue) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setTextValue(textValue);
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public int getHourOffset() {
        return this.hourOffset;
    }

    @Override
    public int getMinuteOffset() {
        return this.minuteOffset;
    }

    @Override
    public String getIso8601Offset() {
        return ISOUtils.toISO8601_TimeZone(this.timeZone, ISOFormat.ISO8601_EXTENDED);
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public TimeZoneParameterType getTimeZoneParameterType() {
        return this.timeZoneParameterType;
    }

    @Override
    public void parseTimeZoneOffset(String iso8601Offset) {
        String[] tz = iso8601Offset.split(":");
        this.hourOffset = Integer.parseInt(tz[0]);
        this.minuteOffset = Integer.parseInt(tz[1]);
        this.calculateTimeZone();
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public void setTimeZoneParameterType(TimeZoneParameterType timeZoneParameterType) {
        this.timeZoneParameterType = timeZoneParameterType;
    }

    @Override
    public void setHourOffset(int hourOffset) {
        this.hourOffset = hourOffset;
        this.calculateTimeZone();
    }

    @Override
    public void setMinuteOffset(int minuteOffset) {
        this.minuteOffset = minuteOffset;
        this.calculateTimeZone();
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
        this.hourOffset = 0;
        this.minuteOffset = 0;
        this.timeZone = null;
    }

    private void calculateTimeZone() {
        int offsetMillis = this.hourOffset + this.minuteOffset / 10;
        offsetMillis = offsetMillis * 60 * 60 * 1000;
        this.timeZone.setRawOffset(offsetMillis);
        this.textValue = ISOUtils.toISO8601_TimeZone(this.timeZone, ISOFormat.ISO8601_EXTENDED);
    }

    @Override
    public String getTypeString() {
        return VCardType.TZ.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof TimeZoneType) {
                return this == obj || ((TimeZoneType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.timeZone != null) {
            sb.append(this.timeZone.getRawOffset());
            sb.append(",");
        }
        if (this.timeZoneParameterType != null) {
            sb.append(this.timeZoneParameterType.getType());
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public TimeZoneFeature clone() {
        TimeZoneType cloned = new TimeZoneType();
        if (this.timeZone != null) {
            TimeZone tz = TimeZone.getDefault();
            tz.setRawOffset(this.timeZone.getRawOffset());
            cloned.setTimeZone(tz);
        } else if (this.textValue != null) {
            cloned.setTextValue(this.textValue);
        } else {
            cloned.setTextValue(null);
            cloned.setTimeZone(null);
        }
        if (this.timeZoneParameterType != null) {
            cloned.setTimeZoneParameterType(this.timeZoneParameterType);
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

