/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.UIDFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;

public class UIDType
extends Type
implements UIDFeature {
    private String uid = null;

    public UIDType() {
        this((String)null);
    }

    public UIDType(String uid) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setUID(uid);
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public void setUID(String uid) {
        this.uid = uid;
    }

    @Override
    public void clearUID() {
        this.uid = null;
    }

    @Override
    public boolean hasUID() {
        return this.uid != null;
    }

    @Override
    public String getTypeString() {
        return VCardType.UID.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof UIDType) {
                return this == obj || ((UIDType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.uid != null) {
            sb.append(this.uid);
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public UIDFeature clone() {
        UIDType cloned = new UIDType();
        if (this.uid != null) {
            cloned.setUID(this.uid);
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

