/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.URLFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import java.net.MalformedURLException;
import java.net.URL;

public class URLType
extends Type
implements URLFeature {
    private URL url = null;

    public URLType() {
        this((URL)null);
    }

    public URLType(URL url) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setURL(url);
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public void setURL(URL url) {
        this.url = url;
    }

    @Override
    public void clearURL() {
        this.url = null;
    }

    @Override
    public boolean hasURL() {
        return this.url != null;
    }

    @Override
    public String getTypeString() {
        return VCardType.URL.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof URLType) {
                return this == obj || ((URLType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.url != null) {
            sb.append(this.url);
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public URLFeature clone() {
        URLType cloned = new URLType();
        if (this.url != null) {
            try {
                cloned.setURL(new URL(this.url.toString()));
            }
            catch (MalformedURLException e) {
                cloned.setURL(null);
            }
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

