/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.VCardVersion;
import info.ineighborhood.cardme.vcard.features.VersionFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;

public class VersionType
extends Type
implements VersionFeature {
    private VCardVersion version = null;

    public VersionType() {
    }

    public VersionType(VCardVersion version) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setVersion(version);
    }

    @Override
    public VCardVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(VCardVersion version) throws NullPointerException {
        if (version == null) {
            throw new NullPointerException("version cannot be null.");
        }
        this.version = version;
    }

    @Override
    public String getTypeString() {
        return VCardType.VERSION.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof VersionType) {
                return this == obj || ((VersionType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.version != null) {
            sb.append(this.version.getVersion());
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public VersionFeature clone() {
        VersionType cloned = new VersionType();
        if (this.version != null) {
            cloned.setVersion(this.version);
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

