/*
 * Decompiled with CFR 0.152.
 */
package io.milton.principal;

import io.milton.http.Auth;
import io.milton.principal.DavPrincipal;
import io.milton.principal.Principal;
import io.milton.resource.Resource;
import javax.xml.namespace.QName;

public class DavPrincipals {
    public static DavPrincipal All = new AllDavPrincipal();
    public static DavPrincipal AUTHENTICATED = new AllDavPrincipal();
    public static DavPrincipal UNAUTHENTICATED = new UnAuthenticatedDavPrincipal();

    public static class UnAuthenticatedDavPrincipal
    extends AbstractDavPrincipal {
        UnAuthenticatedDavPrincipal() {
            super("unauthenticated");
        }

        @Override
        public boolean matches(Auth auth, Resource current) {
            return auth.getTag() == null;
        }
    }

    public static class AuthenticatedDavPrincipal
    extends AbstractDavPrincipal {
        AuthenticatedDavPrincipal() {
            super("authenticated");
        }

        @Override
        public boolean matches(Auth auth, Resource current) {
            return auth.getTag() != null;
        }
    }

    public static class AllDavPrincipal
    extends AbstractDavPrincipal {
        AllDavPrincipal() {
            super("all");
        }

        @Override
        public boolean matches(Auth auth, Resource current) {
            return true;
        }
    }

    public static abstract class AbstractDavPrincipal
    implements DavPrincipal {
        private final Principal.PrincipleId id;
        private final QName qname;

        public AbstractDavPrincipal(String name) {
            this.qname = new QName("DAV:", name);
            this.id = new Principal.PrincipleId(){

                @Override
                public QName getIdType() {
                    return qname;
                }

                @Override
                public String getValue() {
                    return null;
                }
            };
        }

        @Override
        public Principal.PrincipleId getIdenitifer() {
            return this.id;
        }
    }
}

