/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

public class Range {
    private final Long start;
    private final Long finish;

    public static Range parse(String s) {
        String[] arr = s.trim().split("-");
        if (arr.length == 0 || arr.length > 2) {
            throw new RuntimeException("Invalid range. Use format start-finish, eg 1000-1500. Range:" + s + " parts=" + arr.length);
        }
        try {
            Long start = null;
            if (arr[0].length() > 0) {
                start = Long.parseLong(arr[0]);
            }
            Long finish = null;
            if (arr.length > 1 && arr[1].length() > 0) {
                finish = Long.parseLong(arr[1]);
            }
            return new Range(start, finish);
        }
        catch (Throwable e) {
            throw new RuntimeException("Invalid range. Use format start-finish, eg 1000-1500. Range:" + s, e);
        }
    }

    public Range(int start, int finish) {
        this.start = start;
        this.finish = finish;
    }

    public Range(Long start, Long finish) {
        this.start = start;
        this.finish = finish;
    }

    public Long getStart() {
        return this.start;
    }

    public Long getFinish() {
        return this.finish;
    }

    public Long getLength() {
        if (this.start != null && this.finish != null) {
            return this.finish - this.start + 1L;
        }
        return null;
    }

    public String toString() {
        return "bytes " + this.start + "-" + this.finish;
    }

    public String getRange() {
        String s = "";
        if (this.start != null) {
            s = s + this.start;
        }
        s = s + "-";
        if (this.finish != null) {
            s = s + this.finish;
        }
        return s;
    }
}

