/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.http.Auth;
import io.milton.http.Cookie;
import io.milton.http.FileItem;
import io.milton.http.RequestParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public interface Request {
    public Map<String, String> getHeaders();

    public String getFromAddress();

    public String getLockTokenHeader();

    public String getRequestHeader(Header var1);

    public Method getMethod();

    public Auth getAuthorization();

    public void setAuthorization(Auth var1);

    public String getRefererHeader();

    public String getTimeoutHeader();

    public String getIfHeader();

    public String getIfRangeHeader();

    public String getIfMatchHeader();

    public String getIfNoneMatchHeader();

    public Date getIfModifiedHeader();

    public int getDepthHeader();

    public String getAbsoluteUrl();

    public String getAbsolutePath();

    public String getHostHeader();

    public String getDestinationHeader();

    public String getExpectHeader();

    public InputStream getInputStream() throws IOException;

    public void parseRequestParameters(Map<String, String> var1, Map<String, FileItem> var2) throws RequestParseException;

    public String getContentTypeHeader();

    public Long getContentLengthHeader();

    public String getAcceptHeader();

    public String getAcceptEncodingHeader();

    public String getAcceptLanguage();

    public String getRangeHeader();

    public String getContentRangeHeader();

    public Boolean getOverwriteHeader();

    public String getOriginHeader();

    public String getUserAgentHeader();

    public Map<String, Object> getAttributes();

    public Map<String, String> getParams();

    public Map<String, FileItem> getFiles();

    public Cookie getCookie(String var1);

    public List<Cookie> getCookies();

    public String getRemoteAddr();

    public Locale getLocale();

    public static enum Method {
        HEAD("HEAD", false),
        PROPFIND("PROPFIND", false),
        PROPPATCH("PROPPATCH", true),
        MKCOL("MKCOL", true),
        MKCALENDAR("MKCALENDAR", true),
        COPY("COPY", true),
        MOVE("MOVE", true),
        LOCK("LOCK", true),
        UNLOCK("UNLOCK", true),
        DELETE("DELETE", true),
        GET("GET", false),
        OPTIONS("OPTIONS", false),
        POST("POST", true),
        PUT("PUT", true),
        TRACE("TRACE", false),
        ACL("ACL", true),
        CONNECT("CONNECT", true),
        CANCELUPLOAD("CANCELUPLOAD", true),
        REPORT("REPORT", false);

        public final String code;
        public final boolean isWrite;

        private Method(String code, boolean isWrite) {
            this.code = code;
            this.isWrite = isWrite;
        }
    }

    public static enum Header {
        CACHE_CONTROL("Cache-Control"),
        WWW_AUTHENTICATE("WWW-Authenticate"),
        IF("If"),
        IF_RANGE("If-Range"),
        IF_MATCH("If-Match"),
        IF_NONE_MATCH("If-None-Match"),
        IF_MODIFIED("If-Modified-Since"),
        IF_NOT_MODIFIED("If-Unmodified-Since"),
        CONTENT_LENGTH("Content-Length"),
        CONTENT_TYPE("Content-Type"),
        CONTENT_RANGE("Content-Range"),
        DEPTH("Depth"),
        HOST("Host"),
        DESTINATION("Destination"),
        REFERER("Referer"),
        ACCEPT("Accept"),
        ACCEPT_LANGUAGE("Accept-Language"),
        RANGE("Range"),
        ACCEPT_ENCODING("Accept-Encoding"),
        TIMEOUT("Timeout"),
        LOCK_TOKEN("Lock-Token"),
        EXPECT("Expect"),
        OVERWRITE("Overwrite"),
        ORIGIN("Origin"),
        USER_AGENT("User-Agent"),
        X_EXPECTED_ENTITY_LENGTH("X-Expected-Entity-Length"),
        AUTHORIZATION("Authorization");

        public final String code;

        private Header(String code) {
            this.code = code;
        }
    }

    public static enum CacheControlRequest {
        NO_CACHE("no-cache"),
        NO_STORE("no-store"),
        MAX_AGE("max-age"),
        MAX_STALE("max-stale"),
        MIN_FRESH("min-fresh"),
        NO_TRANSFORM("no-transform"),
        ONLY_IF_CACHED("only-if-cached"),
        CACHE_EXT("cache-extension");

        public final String code;

        private CacheControlRequest(String code) {
            this.code = code;
        }
    }

    public static enum Depth {
        ZERO,
        ONE,
        INFINITY;

    }
}

