/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import io.milton.common.ContentTypeService;
import io.milton.common.DefaultContentTypeService;
import io.milton.common.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ContentTypeUtils {
    private static final ContentTypeService contentTypeService = new DefaultContentTypeService();

    private ContentTypeUtils() {
    }

    public static String findContentTypes(String name) {
        List<String> list = contentTypeService.findContentTypes(name);
        return ContentTypeUtils.buildContentTypeText(list);
    }

    public static String findContentTypes(File file) {
        return ContentTypeUtils.buildContentTypeText(contentTypeService.findContentTypes(file.getName()));
    }

    public static String findAcceptableContentType(String canProvide, String accepts) {
        return contentTypeService.getPreferedMimeType(accepts, ContentTypeUtils.toList(canProvide));
    }

    public static String findAcceptableContentTypeForName(String name, String accepts) {
        String canProvide = ContentTypeUtils.findContentTypes(name);
        List<String> canProvideList = ContentTypeUtils.toList(canProvide);
        return contentTypeService.getPreferedMimeType(accepts, canProvideList);
    }

    public static List<String> toList(String string) {
        ArrayList<String> list = new ArrayList<String>();
        if (string != null) {
            for (String x : string.split(",")) {
                x = x.trim();
                list.add(x);
            }
        }
        return list;
    }

    private static String buildContentTypeText(List<String> mimeTypes) {
        return Utils.toCsv(mimeTypes);
    }
}

