/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import io.milton.common.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class FileUtils {
    public void copy(File source, File dest) {
        try (FileInputStream is = new FileInputStream(source);
             FileOutputStream os = new FileOutputStream(dest);){
            int i = is.read();
            while (i >= 0) {
                os.write(i);
                i = is.read();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static ByteArrayOutputStream readIn(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamUtils.readTo(is, (OutputStream)os, true, true);
        return os;
    }

    public static String readResource(Class cl, String res) throws IOException {
        InputStream in = cl.getResourceAsStream(res);
        if (in == null) {
            throw new IOException("Failed to read resource: " + res + " relative to class: " + cl.getCanonicalName());
        }
        ByteArrayOutputStream out = FileUtils.readIn(in);
        return out.toString();
    }

    public static void close(InputStream in) {
        try {
            if (in == null) {
                return;
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Closeable in) {
        try {
            if (in == null) {
                return;
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Object object) {
        if (object == null) {
            return;
        }
        try {
            Method m = object.getClass().getMethod("close", new Class[0]);
            m.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public InputStream openFile(File file) throws FileNotFoundException {
        FileInputStream fin = null;
        BufferedInputStream br = null;
        fin = new FileInputStream(file);
        br = new BufferedInputStream(fin);
        return br;
    }

    public OutputStream openFileForWrite(File file) throws FileNotFoundException {
        FileOutputStream fout = new FileOutputStream(file);
        return new BufferedOutputStream(fout);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String readFile(File file) throws FileNotFoundException {
        try (FileReader fr = new FileReader(file);){
            String string;
            try (BufferedReader br = new BufferedReader(fr);){
                String s;
                StringBuilder sb = new StringBuilder();
                while ((s = br.readLine()) != null) {
                    sb.append(s);
                    sb.append("\n");
                }
                string = sb.toString();
            }
            return string;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String read(InputStream in) {
        try {
            int s;
            BufferedInputStream bin = new BufferedInputStream(in);
            byte[] buf = new byte[1024];
            StringBuilder sb = new StringBuilder();
            while ((s = bin.read(buf)) > -1) {
                sb.append(new String(buf, 0, s));
            }
            return sb.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public File resolveRelativePath(File start, String path) {
        String[] arr = path.split("/");
        File f = start;
        for (String s : arr) {
            f = s.equals("..") ? f.getParentFile() : new File(f, s);
        }
        return f;
    }

    public static String getExtension(File file) {
        return FileUtils.getExtension(file.getName());
    }

    public static String getExtension(String name) {
        if (name == null) {
            return null;
        }
        try {
            int pos = name.lastIndexOf(".");
            if (pos > -1) {
                return name.substring(pos + 1);
            }
            return null;
        }
        catch (Throwable e) {
            throw new RuntimeException(name, e);
        }
    }

    public static String stripExtension(String name) {
        if (name.contains(".")) {
            String[] arr = name.split("[.]");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arr.length - 1; ++i) {
                if (arr[i] == null) continue;
                if (i != 0) {
                    sb.append(".");
                }
                sb.append(arr[i]);
            }
            return sb.toString();
        }
        return name;
    }

    public static String preprendExtension(String filename, String newExt) {
        String ext = FileUtils.getExtension(filename);
        filename = FileUtils.stripExtension(filename);
        filename = filename + "." + newExt + "." + ext;
        return filename;
    }

    public static String incrementFileName(String name, boolean isFirst) {
        int count;
        String mainName = FileUtils.stripExtension(name);
        String ext = FileUtils.getExtension(name);
        if (isFirst) {
            count = 1;
        } else {
            int pos = mainName.lastIndexOf("(");
            if (pos > 0) {
                String sNum = mainName.substring(pos + 1, mainName.length() - 1);
                count = Integer.parseInt(sNum) + 1;
                mainName = mainName.substring(0, pos);
            } else {
                count = 1;
            }
        }
        String s = mainName + "(" + count + ")";
        if (ext != null) {
            s = s + "." + ext;
        }
        return s;
    }

    public static String sanitiseName(String s) {
        s = s.replaceAll("[ ]", "_");
        return s;
    }

    public static void readLines(File file, List<String> lines) {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            for (Object oLine : IOUtils.readLines((InputStream)in)) {
                lines.add(oLine.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(file.getAbsolutePath(), e);
        }
    }

    public static void writeLines(File file, List<String> lines) {
        try (FileOutputStream fout = new FileOutputStream(file);){
            IOUtils.writeLines(lines, null, (OutputStream)fout);
        }
        catch (Exception e) {
            throw new RuntimeException(file.getAbsolutePath(), e);
        }
    }
}

