/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import io.milton.common.FileUtils;
import io.milton.common.Utils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Formatter {
    private static final Logger log = LoggerFactory.getLogger(Formatter.class);
    public static final String CHECKBOX_SUFFIX = "_checkbox";
    public static ThreadLocal<DateFormat> tlSdfUkShort = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd/MM/yyyy"));
    public static ThreadLocal<DateFormat> tlSdfUkLong = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd MMMM yyyy"));
    public static final ThreadLocal<DateFormat> sdfDateOnly = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd/MM/yyyy"));
    public static final ThreadLocal<DateFormat> sdfDateAndTime = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd/MM/yyyy HH:mm"));

    public String toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public Boolean toBool(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i == 0;
        }
        if (object instanceof String) {
            String s = (String)object;
            s = s.toLowerCase();
            if (!(s = s.trim()).isEmpty()) {
                return s.equals("true") || s.equals("yes");
            }
            return null;
        }
        throw new RuntimeException("Unsupported boolean type: " + object.getClass());
    }

    public BigDecimal toDecimal(Object object, int places) {
        if (object == null) {
            return BigDecimal.ZERO;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)object;
            return bd.setScale(places, RoundingMode.HALF_UP);
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return BigDecimal.valueOf(d).setScale(places, RoundingMode.HALF_UP);
        }
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return BigDecimal.valueOf(i.longValue()).setScale(places, RoundingMode.HALF_UP);
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return BigDecimal.valueOf(f.doubleValue()).setScale(places, RoundingMode.HALF_UP);
        }
        if (object instanceof String) {
            String s = (String)object;
            if ((s = s.trim()).isEmpty()) {
                return BigDecimal.ZERO;
            }
            try {
                return new BigDecimal(s).setScale(places, RoundingMode.HALF_UP);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Non-numeric data: " + s);
            }
        }
        throw new RuntimeException("Unsupported value type, should be numeric: " + object.getClass());
    }

    public Double toDouble(Object object) {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof String) {
            String s = (String)object;
            if ((s = s.trim()).isEmpty()) {
                return 0.0;
            }
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Non-numeric data: " + s);
            }
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return (double)i;
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return f.doubleValue();
        }
        if (object instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)object;
            return bd.doubleValue();
        }
        throw new RuntimeException("Unsupported value type, should be numeric: " + object.getClass());
    }

    public Long toLong(Object oLimit) {
        return this.toLong(oLimit, false);
    }

    public Long toLong(Object object, boolean withNulls) {
        Long limit;
        if (object == null) {
            limit = withNulls ? null : Long.valueOf(0L);
        } else if (object instanceof Long) {
            limit = (Long)object;
        } else if (object instanceof Integer) {
            int i = (Integer)object;
            limit = i;
        } else {
            if (object instanceof Double) {
                Double d = (Double)object;
                return d.longValue();
            }
            if (object instanceof Float) {
                Float d = (Float)object;
                return d.longValue();
            }
            if (object instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)object;
                return bd.longValue();
            }
            if (object instanceof Boolean) {
                Boolean bb = (Boolean)object;
                return Boolean.TRUE.equals(bb) ? 1L : 0L;
            }
            if (object instanceof String) {
                String s = (String)object;
                if (s.isEmpty()) {
                    limit = withNulls ? null : Long.valueOf(0L);
                } else {
                    if (s.equals("true") || s.equals("false")) {
                        Boolean b = Boolean.parseBoolean(s);
                        return this.toLong(b);
                    }
                    if (s.contains(".")) {
                        Double d = this.toDouble(s);
                        limit = d.longValue();
                    } else {
                        limit = Long.parseLong(s);
                    }
                }
            } else {
                throw new RuntimeException("unsupported class: " + object.getClass());
            }
        }
        return limit;
    }

    public int getYear(Object object) {
        if (!(object instanceof java.util.Date)) {
            return 0;
        }
        java.util.Date dt = (java.util.Date)object;
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        return cal.get(1);
    }

    public int getMonth(Object object) {
        if (!(object instanceof java.util.Date)) {
            return 0;
        }
        java.util.Date dt = (java.util.Date)object;
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        return cal.get(2) + 1;
    }

    public int getDayOfMonth(Object object) {
        if (!(object instanceof java.util.Date)) {
            return 0;
        }
        java.util.Date dt = (java.util.Date)object;
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        return cal.get(5) + 1;
    }

    public String formatMinsAsDuration(Object o) {
        return this.formatMinsAsDuration(o, true);
    }

    public String formatMinsAsDuration(Object object, boolean numeric) {
        Long l = this.toLong(object);
        if (l == null) {
            return "";
        }
        if (l == 0L) {
            return "";
        }
        long hours = l / 60L;
        long mins = l % 60L;
        if (numeric) {
            return hours + ":" + this.pad(mins, 2);
        }
        if (hours == 0L) {
            return mins + "mins";
        }
        if (hours == 1L) {
            return hours + "hr " + mins;
        }
        return hours + "hrs " + mins;
    }

    public String pad2(long l) {
        return this.pad(l, 2);
    }

    public String pad(long l, int length) {
        return this.padWith("0", l, length);
    }

    public String padWith(String padChar, long l, int length) {
        return this._pad(padChar, l + "", length);
    }

    private String _pad(String padChar, String val, int length) {
        if (val.length() >= length) {
            return val;
        }
        return this._pad(padChar, padChar + val, length);
    }

    public String toPercent(Object num, Object div) {
        return this.toPercent(num, div, true, true);
    }

    public String toPercent(Object num, Object div, boolean appendSymbol, boolean withBlanks) {
        Long lNum = this.toLong(num, true);
        Long lDiv = this.toLong(div, true);
        if (lDiv == null || lDiv == 0L || lNum == null) {
            if (withBlanks) {
                return "";
            }
            return "0" + (appendSymbol ? "%" : "");
        }
        long perc = lNum * 100L / lDiv;
        return perc + (appendSymbol ? "%" : "");
    }

    public String stripExt(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        return FileUtils.stripExtension(s);
    }

    public boolean gt(Object val1, Object val2) {
        if (val1 == null) {
            return false;
        }
        if (val2 == null) {
            return true;
        }
        Double d1 = this.toDouble(val1);
        Double d2 = this.toDouble(val2);
        return d1 > d2;
    }

    public boolean lt(Object val1, Object val2) {
        if (val1 == null) {
            return false;
        }
        if (val2 == null) {
            return true;
        }
        Double d1 = this.toDouble(val1);
        Double d2 = this.toDouble(val2);
        return d1 < d2;
    }

    public boolean eq(Object val1, Object val2) {
        Double d2;
        if (val1 == null) {
            return val2 == null;
        }
        if (val2 == null) {
            return false;
        }
        Double d1 = this.toDouble(val1);
        return d1 == (d2 = this.toDouble(val2));
    }

    public String percentDecode(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        return Utils.decodePath(s);
    }

    public String percentEncode(String s) {
        if (s == null) {
            return null;
        }
        return Utils.percentEncode(s);
    }

    public java.util.Date toDate(Object oVal) {
        if (oVal == null) {
            return null;
        }
        if (oVal instanceof java.util.Date) {
            return (java.util.Date)oVal;
        }
        if (oVal instanceof String) {
            String s = (String)oVal;
            return this.parseDate(s);
        }
        return null;
    }

    public Date toSqlDate(Object oVal) {
        java.util.Date dt = this.toDate(oVal);
        if (dt == null) {
            return null;
        }
        return new Date(dt.getTime());
    }

    public Timestamp toSqlTimestamp(Object oVal) {
        java.util.Date dt = this.toDate(oVal);
        if (dt == null) {
            return null;
        }
        return new Timestamp(dt.getTime());
    }

    public String toPlain(String html) {
        if (html == null) {
            return null;
        }
        html = this.replaceTag("br", html, "", "\n");
        html = this.replaceTag("p", html, "", "\n");
        html = this.replaceTag("b", html, "", "");
        html = this.replaceTag("i", html, "", "");
        html = this.replaceTag("h1", html, "", "");
        html = this.replaceTag("h2", html, "", "");
        html = this.replaceTag("h3", html, "", "");
        return html;
    }

    private String replaceTag(String tag, String html, String replaceWithOpening, String replaceWithClosing) {
        html = html.replace("<" + tag + "/>", replaceWithClosing);
        html = html.replace("<" + tag + ">", replaceWithOpening);
        html = html.replace("</" + tag + ">", replaceWithClosing);
        return html;
    }

    public String getMonthName(int i) {
        switch (i) {
            case 0: {
                return "January";
            }
            case 1: {
                return "February";
            }
            case 2: {
                return "March";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "June";
            }
            case 6: {
                return "July";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "October";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "December";
            }
        }
        return "Unknown month " + i;
    }

    public String ifEqual(String ifEqual, String ifNoteEqual, Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null ? ifEqual : ifNoteEqual;
        }
        return o1.equals(o2) ? ifEqual : ifNoteEqual;
    }

    public Object ifTrue(Object bb, Object o1, Object o2) {
        Boolean b = this.toBool(bb);
        if (b == null) {
            b = Boolean.FALSE;
        }
        return b != false ? o1 : o2;
    }

    private java.util.Date parseDate(String s) {
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        try {
            java.util.Date dt = s.contains(":") ? this.sdf(true).parse(s) : this.sdf(false).parse(s);
            return dt;
        }
        catch (ParseException ex) {
            log.warn("couldnt parse date", (Throwable)ex);
            return null;
        }
    }

    public DateFormat sdf(boolean hasTime) {
        if (hasTime) {
            return sdfDateAndTime.get();
        }
        return sdfDateOnly.get();
    }

    public BigDecimal toBigDecimal(Object o, int decimals) {
        if (o instanceof Integer) {
            Integer ii = (Integer)o;
            return new BigDecimal(ii);
        }
        if (o instanceof Double) {
            Double dd = (Double)o;
            return BigDecimal.valueOf(dd).setScale(decimals, RoundingMode.HALF_UP);
        }
        if (o instanceof Float) {
            Float ff = (Float)o;
            return BigDecimal.valueOf(ff.floatValue());
        }
        if (o instanceof String) {
            Double dd = this.toDouble(o);
            return this.toBigDecimal(dd, decimals);
        }
        log.warn("unhandled type: {}", o.getClass());
        return null;
    }

    public String checkbox(String name, Object oChecked) {
        return this.checkbox(null, name, oChecked, "true");
    }

    public String checkbox(String id, String name, Object oChecked) {
        return this.checkbox(id, name, oChecked, "true");
    }

    public String checkbox(String id, String name, Object oChecked, String value) {
        Boolean checked = this.toBool(oChecked);
        if (checked == null) {
            checked = Boolean.FALSE;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<input type='hidden' value='' name='").append(name).append(CHECKBOX_SUFFIX).append("'/>");
        sb.append("<input type=\"checkbox\"");
        sb.append(" name=\"").append(name).append("\" ");
        if (checked.booleanValue()) {
            sb.append("checked=\"true\"");
        }
        this.appendValue(sb, value);
        if (id != null) {
            sb.append(" id=\"").append(id).append("\"");
        }
        sb.append(" />");
        return sb.toString();
    }

    public String radio(String id, String name, Object oChecked, String value) {
        Boolean checked = this.toBool(oChecked);
        if (checked == null) {
            checked = Boolean.FALSE;
        }
        StringBuilder sb = new StringBuilder("<input type=\"radio\"");
        sb.append(" name=\"").append(name).append("\"");
        if (checked.booleanValue()) {
            sb.append(" checked=\"true\"");
        }
        this.appendValue(sb, value);
        if (id != null) {
            sb.append(" id=\"").append(id).append("\"");
        }
        sb.append(" />");
        return sb.toString();
    }

    public String option(Object value, String text, Object currentValue) {
        StringBuilder sb = new StringBuilder("<option");
        this.appendValue(sb, value);
        if (currentValue != null && currentValue.equals(value)) {
            sb.append("selected=\"true\"");
        }
        sb.append(">");
        sb.append(text).append("</option>");
        return sb.toString();
    }

    private void appendValue(StringBuilder sb, Object value) {
        sb.append(" value=");
        sb.append("\"");
        if (value != null) {
            sb.append(value);
        }
        sb.append("\"");
    }

    public String toCsv(Iterable list) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            for (Object o : list) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(o.toString());
            }
        }
        return sb.toString();
    }

    public String toCsv(String[] list) {
        return this.toCsv(Arrays.asList(list));
    }

    public java.util.Date addDays(java.util.Date now, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.add(6, days);
        return cal.getTime();
    }
}

