/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RandomFileOutputStream
extends OutputStream {
    protected RandomAccessFile randomFile;
    protected boolean sync;

    public RandomFileOutputStream(String fileName) throws IOException {
        this(fileName, false);
    }

    public RandomFileOutputStream(String fileName, boolean sync) throws IOException {
        this(new File(fileName), sync);
    }

    public RandomFileOutputStream(File file) throws IOException {
        this(file, false);
    }

    public RandomFileOutputStream(File file, boolean sync) throws IOException {
        this.randomFile = new RandomAccessFile(file, "rw");
        this.sync = sync;
    }

    @Override
    public void write(int val) throws IOException {
        this.randomFile.write(val);
        if (this.sync) {
            this.randomFile.getFD().sync();
        }
    }

    @Override
    public void write(byte[] val) throws IOException {
        this.randomFile.write(val);
        if (this.sync) {
            this.randomFile.getFD().sync();
        }
    }

    @Override
    public void write(byte[] val, int off, int len) throws IOException {
        this.randomFile.write(val, off, len);
        if (this.sync) {
            this.randomFile.getFD().sync();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.sync) {
            this.randomFile.getFD().sync();
        }
    }

    @Override
    public void close() throws IOException {
        this.randomFile.close();
    }

    public long getFilePointer() throws IOException {
        return this.randomFile.getFilePointer();
    }

    public void setFilePointer(long pos) throws IOException {
        this.randomFile.seek(pos);
    }

    public long getFileSize() throws IOException {
        return this.randomFile.length();
    }

    public void setFileSize(long length) throws IOException {
        this.randomFile.setLength(length);
    }

    public FileDescriptor getFD() throws IOException {
        return this.randomFile.getFD();
    }
}

