/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import io.milton.common.StreamUtils;
import io.milton.http.Range;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class RangeUtils {
    private RangeUtils() {
    }

    public static String toRangeString(long start, long finish, Long totalLength) {
        String s;
        String l;
        String string = l = totalLength == null ? "*" : totalLength.toString();
        if (finish > -1L) {
            s = "bytes " + start + "-" + finish + "/" + l;
        } else {
            long wrotetill = totalLength == null ? 0L : totalLength - 1L;
            s = "bytes " + start + "-" + wrotetill + "/" + l;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRanges(InputStream in, List<Range> ranges, OutputStream responseOut) throws IOException {
        try {
            long pos = 0L;
            for (Range r : ranges) {
                long skip = r.getStart() - pos;
                in.skip(skip);
                Long length = r.getLength();
                if (length == null) {
                    throw new IOException("Unable to write range because either start or finish index are not provided: " + r);
                }
                RangeUtils.sendBytes(in, responseOut, length);
                pos = r.getFinish();
            }
        }
        finally {
            StreamUtils.close(in);
        }
    }

    public static void sendBytes(InputStream in, OutputStream out, long length) throws IOException {
        long remainingBytes;
        int maxLength;
        int s;
        byte[] b = new byte[1024];
        for (long numRead = 0L; numRead < length && (s = in.read(b, 0, maxLength = (remainingBytes = length - numRead) > 1024L ? 1024 : (int)remainingBytes)) >= 0; numRead += (long)s) {
            out.write(b, 0, s);
        }
    }

    public static void writeRange(InputStream in, Range range, OutputStream responseOut) throws IOException {
        if (range != null) {
            if (range.getStart() != null) {
                long skip = range.getStart();
                in.skip(skip);
            }
            if (range.getFinish() != null) {
                long length = range.getFinish() - range.getStart() + 1L;
                RangeUtils.sendBytes(in, responseOut, length);
            } else {
                IOUtils.copy((InputStream)in, (OutputStream)responseOut);
            }
        } else {
            IOUtils.copy((InputStream)in, (OutputStream)responseOut);
        }
    }
}

