/*
 * Decompiled with CFR 0.152.
 */
package io.milton.resource;

import io.milton.http.Auth;
import io.milton.http.values.HrefList;
import io.milton.principal.Principal;
import io.milton.resource.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface AccessControlledResource
extends Resource {
    public static final List<Priviledge> NONE = Collections.emptyList();
    public static final List<Priviledge> READ_WRITE = Arrays.asList(Priviledge.READ, Priviledge.WRITE);
    public static final List<Priviledge> READ_CONTENT = Collections.singletonList(Priviledge.READ_CONTENT);
    public static final List<Priviledge> READ_BROWSE = Arrays.asList(Priviledge.READ_CONTENT, Priviledge.READ_PROPERTIES);

    public String getPrincipalURL();

    public List<Priviledge> getPriviledges(Auth var1);

    public Map<Principal, List<Priviledge>> getAccessControlList();

    public void setAccessControlList(Map<Principal, List<Priviledge>> var1);

    public HrefList getPrincipalCollectionHrefs();

    public static enum Priviledge {
        READ_CONTENT(Collections.emptyList()),
        READ_PROPERTIES(Collections.emptyList()),
        READ_CURRENT_USER_PRIVILEDGE(Collections.emptyList()),
        READ_ACL(Collections.emptyList()),
        READ(Arrays.asList(READ_CONTENT, READ_PROPERTIES, READ_ACL, READ_CURRENT_USER_PRIVILEDGE)),
        WRITE_PROPERTIES(Collections.emptyList()),
        WRITE_CONTENT(Collections.emptyList()),
        WRITE_ACL(Collections.emptyList()),
        UNLOCK(Collections.emptyList()),
        WRITE(Arrays.asList(WRITE_CONTENT, WRITE_PROPERTIES, WRITE_ACL, UNLOCK)),
        BIND(Collections.emptyList()),
        UNBIND(Collections.emptyList()),
        ALL(Arrays.asList(READ, WRITE, BIND, UNBIND));

        public final List<Priviledge> contains;

        private Priviledge(List<Priviledge> contains) {
            this.contains = contains;
        }
    }
}

