/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail;

import com.sun.mail.smtp.SMTPMessage;
import io.milton.common.ReadingException;
import io.milton.common.StreamUtils;
import io.milton.common.WritingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Email {
    private static final Logger log = LoggerFactory.getLogger(Email.class);
    private Address from;
    public final Recipients recipients = new Recipients();
    public final Attachments attachments = new Attachments();
    private String subject;
    private String text;
    private String html;

    public static Email fromStream(InputStream in) throws MessagingException, IOException {
        SMTPMessage mm = new SMTPMessage(Email.createSession(), in);
        return Email.fromMessage(mm);
    }

    public static Email fromMessage(SMTPMessage mm) throws MessagingException, IOException {
        int i;
        Multipart mp;
        Email email = new Email();
        email.setSubject(mm.getSubject());
        Address[] froms = mm.getFrom();
        if (froms == null || froms.length == 0) {
            throw new IllegalArgumentException("no from");
        }
        email.setFrom(froms[0]);
        email.recipients.addTo(mm.getRecipients(Message.RecipientType.TO));
        email.recipients.addCC(mm.getRecipients(Message.RecipientType.CC));
        email.recipients.addBCC(mm.getRecipients(Message.RecipientType.BCC));
        Object oBody = mm.getContent();
        if (oBody instanceof String) {
            email.setText((String)oBody);
        } else if (oBody instanceof Multipart) {
            mp = (Multipart)oBody;
            for (i = 0; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (bp.getContentType().equals("text/plain")) {
                    email.setText(email.getText() + bp.getContent().toString());
                    continue;
                }
                log.warn("content type: " + bp.getContentType());
            }
        }
        mp = (Multipart)mm.getContent();
        int n = mp.getCount();
        for (i = 0; i < n; ++i) {
            BodyPart part = mp.getBodyPart(i);
            String disposition = part.getDisposition();
            if (disposition == null || !disposition.equals("attachment") && !disposition.equals("inline")) continue;
            email.attachments.add(part.getFileName(), part.getContentType(), part.getInputStream());
        }
        return email;
    }

    public static Session createSession() {
        return Session.getDefaultInstance((Properties)new Properties());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Address getFrom() {
        return this.from;
    }

    public void setFrom(Address from) {
        this.from = from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public static class InMemoryAttachment
    implements Attachment {
        final String name;
        final String contentType;
        ByteArrayInputStream data;

        public InMemoryAttachment(String name, String contentType, InputStream data) throws ReadingException, WritingException {
            this.name = name;
            this.contentType = contentType;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamUtils.readTo((InputStream)data, (OutputStream)out);
            this.data = new ByteArrayInputStream(out.toByteArray());
        }

        @Override
        public InputStream getData() {
            return this.data;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }
    }

    public static interface Attachment {
        public String getName();

        public InputStream getData();

        public String getContentType();
    }

    public class Attachments
    implements Iterable<Attachment> {
        List<Attachment> list;

        @Override
        public Iterator<Attachment> iterator() {
            return this.list.iterator();
        }

        public int size() {
            return this.list.size();
        }

        void add(String fileName, String contentType, InputStream inputStream) {
            InMemoryAttachment att;
            try {
                att = new InMemoryAttachment(fileName, contentType, inputStream);
            }
            catch (ReadingException | WritingException ex) {
                throw new RuntimeException(ex);
            }
            this.list.add(att);
        }
    }

    public static class Recipients {
        final List<Address> to = new ArrayList<Address>();
        final List<Address> cc = new ArrayList<Address>();
        final List<Address> bcc = new ArrayList<Address>();

        public void addBCC(Address add) {
            this.to.add(add);
        }

        public void addCC(Address add) {
            this.cc.add(add);
        }

        public void addTo(Address[] recipients) {
            if (recipients == null) {
                return;
            }
            for (Address a : recipients) {
                this.addTo(a);
            }
        }

        public void addTo(Address add) {
            this.bcc.add(add);
        }

        public void addCC(Address[] recipients) {
            if (recipients == null) {
                return;
            }
            for (Address a : recipients) {
                this.addCC(a);
            }
        }

        public void addBCC(Address[] recipients) {
            if (recipients == null) {
                return;
            }
            for (Address a : recipients) {
                this.addBCC(a);
            }
        }
    }
}

