/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail;

import io.milton.mail.Attachment;
import io.milton.mail.MailboxAddress;
import io.milton.mail.StandardMessage;
import io.milton.mail.StandardMessageFactory;
import io.milton.mail.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardMessageFactoryImpl
implements StandardMessageFactory {
    private static final Logger log = LoggerFactory.getLogger(StandardMessageFactoryImpl.class);

    @Override
    public void toStandardMessage(MimeMessage mm, StandardMessage sm) {
        try {
            sm.setFrom(this.findFromAddress(mm));
            sm.setReplyTo(this.findReplyTo(mm));
            sm.setSubject(this.findSubject(mm));
            sm.setDisposition(mm.getDisposition());
            sm.setEncoding(mm.getEncoding());
            sm.setContentLanguage(this.findContentLanguage(mm.getContentLanguage()));
            sm.setTo(this.findRecips(mm, Message.RecipientType.TO));
            sm.setCc(this.findRecips(mm, Message.RecipientType.CC));
            sm.setBcc(this.findRecips(mm, Message.RecipientType.BCC));
            sm.setSize(mm.getSize());
            Map<String, String> headers = this.findHeaders(mm);
            sm.setHeaders(headers);
            Object o = mm.getContent();
            if (o instanceof String) {
                String text = (String)o;
                log.debug("text: " + text);
                sm.setText(text);
            } else if (o instanceof MimeMultipart) {
                MimeMultipart multi = (MimeMultipart)o;
                this.populateMultiPart(multi, sm);
            } else {
                log.warn("Unknown content type: " + o.getClass() + ". expected string or MimeMultipart");
            }
        }
        catch (IOException | MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void populateMultiPart(MimeMultipart multi, StandardMessage sm) throws IOException, MessagingException {
        log.debug("populateMultiPart: content type: " + multi.getContentType());
        for (int i = 0; i < multi.getCount(); ++i) {
            String s;
            BodyPart bp = multi.getBodyPart(i);
            String disp = bp.getDisposition();
            if (disp != null && (disp.equals("attachment") || disp.equals("inline"))) {
                this.addAttachment(sm, bp);
                continue;
            }
            String ct = bp.getContentType();
            if (ct.contains("html")) {
                if (sm.getHtml() == null) {
                    sm.setHtml("");
                }
                s = sm.getHtml() + this.getStringContent(bp);
                sm.setHtml(s);
                continue;
            }
            if (ct.contains("text")) {
                if (sm.getText() == null) {
                    sm.setText("");
                }
                s = sm.getText() + this.getStringContent(bp);
                sm.setText(s);
                continue;
            }
            if (ct.contains("multipart")) {
                Object subMessage = bp.getContent();
                if (subMessage instanceof MimeMultipart) {
                    StandardMessage smSub;
                    MimeMultipart child = (MimeMultipart)subMessage;
                    if (ct.contains("related") || ct.contains("alternative") || ct.contains("mixed")) {
                        smSub = sm;
                    } else {
                        smSub = sm.instantiateAttachedMessage();
                        sm.getAttachedMessages().add(smSub);
                    }
                    this.populateMultiPart(child, smSub);
                    continue;
                }
                log.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!11 unknown sub message type");
                continue;
            }
            this.addAttachment(sm, bp);
        }
    }

    protected void addAttachment(StandardMessage sm, BodyPart bp) {
        InputStream in = null;
        try {
            Object name = bp.getFileName();
            if (name == null) {
                name = "" + System.currentTimeMillis();
            }
            String ct = bp.getContentType();
            log.debug("attachment content type: " + ct);
            String[] contentIdArr = bp.getHeader("Content-ID");
            String contentId = null;
            if (contentIdArr != null && contentIdArr.length > 0) {
                contentId = contentIdArr[0];
                contentId = Utils.parseContentId(contentId);
            }
            in = bp.getInputStream();
            sm.addAttachment((String)name, ct, contentId, bp.getDisposition(), in);
        }
        catch (IOException | MessagingException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                Utils.close(in);
                throw throwable;
            }
        }
        Utils.close(in);
    }

    Map<String, String> findHeaders(MimeMessage mm) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            Enumeration en = mm.getAllHeaders();
            while (en.hasMoreElements()) {
                Object o = en.nextElement();
                Header header = (Header)o;
                map.put(header.getName(), header.getValue());
            }
            return map;
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    void fillRecipients(List<MailboxAddress> to, Address[] recipients) {
        if (recipients == null) {
            return;
        }
        for (Address a : recipients) {
            MailboxAddress ma = MailboxAddress.parse(a.toString());
            to.add(ma);
        }
    }

    void fillContentLanguage(String contentLanguage, MimeMessage mm) {
        try {
            if (contentLanguage == null) {
                return;
            }
            String[] arr = new String[]{contentLanguage};
            mm.setContentLanguage(arr);
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void fillContent(StandardMessage sm, Part message) throws MessagingException {
        if (this.isText(sm)) {
            if (this.isHtml(sm)) {
                if (this.hasAttachments(sm)) {
                    MimeMultipart multipart = new MimeMultipart("mixed");
                    message.setContent((Multipart)multipart);
                    this.addTextAndHtmlToMime(multipart, sm);
                    this.addAttachmentsToMime(multipart, sm);
                } else {
                    log.debug("text and html. no attachments");
                    this.addTextAndHtmlToMime(message, sm);
                }
            } else if (this.hasAttachments(sm)) {
                MimeMultipart multipart = new MimeMultipart("mixed");
                message.setContent((Multipart)multipart);
                this.addTextToMime(multipart, sm);
                this.addAttachmentsToMime(multipart, sm);
            } else {
                message.setContent((Object)sm.getText(), "text/plain; charset=utf-8");
            }
        } else if (this.isHtml(sm)) {
            if (this.hasAttachments(sm)) {
                MimeMultipart multipart = new MimeMultipart("mixed");
                message.setContent((Multipart)multipart);
                this.addHtmlToMime(multipart, sm);
                this.addAttachmentsToMime(multipart, sm);
            } else {
                this.addHtmlToMime(message, sm);
            }
        } else if (this.hasAttachments(sm)) {
            MimeMultipart multipart = new MimeMultipart("mixed");
            message.setContent((Multipart)multipart);
            this.addAttachmentsToMime(multipart, sm);
        } else {
            message.setContent((Object)"", "text/plain; charset=utf-8");
        }
    }

    protected boolean isText(StandardMessage sm) {
        return sm.getText() != null && sm.getText().length() > 0;
    }

    protected boolean isHtml(StandardMessage sm) {
        return sm.getHtml() != null && sm.getHtml().length() > 0;
    }

    protected boolean hasAttachments(StandardMessage sm) {
        return sm.getAttachments() != null && sm.getAttachments().size() > 0 || sm.getAttachedMessages() != null && sm.getAttachedMessages().size() > 0;
    }

    protected void fillReplyTo(StandardMessage sm, MimeMessage mm) {
        try {
            MailboxAddress ma = sm.getReplyTo();
            if (ma == null) {
                return;
            }
            Address[] addresses = new Address[]{ma.toInternetAddress()};
            mm.setReplyTo(addresses);
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addAttachmentToMime(MimeMultipart multipart, Attachment att) throws MessagingException {
        MimeBodyPart bp = new MimeBodyPart();
        AttachmentReadingDataSource fds = new AttachmentReadingDataSource(att);
        bp.setDataHandler(new DataHandler((DataSource)fds));
        bp.setHeader("Content-ID", att.getContentId());
        bp.setDisposition(att.getDisposition());
        bp.setFileName(att.getName());
        multipart.addBodyPart((BodyPart)bp);
    }

    private void addAttachmentsToMime(MimeMultipart multipart, StandardMessage sm) throws MessagingException {
        if (sm.getAttachments() != null && sm.getAttachments().size() > 0) {
            for (Attachment att : sm.getAttachments()) {
                if (!this.isInline(att)) {
                    System.out.println("StandardMessageFactoryImpl - addAttachmentToMime1");
                    this.addAttachmentToMime(multipart, att);
                    continue;
                }
                System.out.println("StandardMessageFactoryImpl - is inline so ignore");
            }
        }
        if (sm.getAttachedMessages() != null && sm.getAttachedMessages().size() > 0) {
            for (StandardMessage smAttached : sm.getAttachedMessages()) {
                MimeBodyPart bp = new MimeBodyPart();
                this.fillContent(smAttached, (Part)bp);
                multipart.addBodyPart((BodyPart)bp);
            }
        }
    }

    private void addHtmlToMime(MimeMultipart multipart, StandardMessage sm) throws MessagingException {
        MimeBodyPart bp = new MimeBodyPart();
        multipart.addBodyPart((BodyPart)bp);
        this.addHtmlToMime((Part)bp, sm);
    }

    private void addHtmlToMime(Part part, StandardMessage sm) throws MessagingException {
        List<Attachment> htmlInline = this.findInlineAttachments(sm);
        if (htmlInline == null || htmlInline.isEmpty()) {
            part.setContent((Object)sm.getHtml(), "text/html; charset=\"utf-8\"");
        } else {
            MimeMultipart related = new MimeMultipart("related");
            part.setContent((Multipart)related);
            MimeBodyPart bpHtml = new MimeBodyPart();
            bpHtml.setHeader("Content-Type", "text/plain; charset=\"utf-8\"");
            bpHtml.setContent((Object)sm.getHtml(), "text/plain; charset=\"utf-8\"");
            related.addBodyPart((BodyPart)bpHtml);
            for (Attachment att : htmlInline) {
                this.addAttachmentToMime(related, att);
            }
        }
    }

    private void addTextAndHtmlToMime(MimeMultipart multipart, StandardMessage sm) throws MessagingException {
        MimeMultipart alternate = this.createTextAndHtml(sm);
        MimeBodyPart bpAlternate = new MimeBodyPart();
        bpAlternate.setContent((Multipart)alternate);
        multipart.addBodyPart((BodyPart)bpAlternate);
    }

    private void addTextAndHtmlToMime(Part message, StandardMessage sm) throws MessagingException {
        MimeMultipart alternate = this.createTextAndHtml(sm);
        message.setContent((Multipart)alternate);
    }

    private MimeMultipart createTextAndHtml(StandardMessage sm) throws MessagingException {
        MimeMultipart alternate = new MimeMultipart("alternative");
        MimeBodyPart bpAlternate = new MimeBodyPart();
        bpAlternate.setContent((Multipart)alternate);
        this.addTextToMime(alternate, sm);
        this.addHtmlToMime(alternate, sm);
        return alternate;
    }

    private void addTextToMime(MimeMultipart multipart, StandardMessage sm) throws MessagingException {
        MimeBodyPart bp = new MimeBodyPart();
        bp.setContent((Object)sm.getText(), "text/plain; charset=utf-8");
        multipart.addBodyPart((BodyPart)bp);
    }

    private void fillBCC(List<MailboxAddress> bcc, MimeMessage mm) {
        this.fillRecipients(bcc, mm, Message.RecipientType.BCC);
    }

    private void fillCC(List<MailboxAddress> cc, MimeMessage mm) {
        this.fillRecipients(cc, mm, Message.RecipientType.CC);
    }

    private void fillRecipients(List<MailboxAddress> list, MimeMessage mm, Message.RecipientType type) {
        for (MailboxAddress ma : list) {
            try {
                mm.addRecipient(type, (Address)ma.toInternetAddress());
            }
            catch (MessagingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void fillTo(List<MailboxAddress> to, MimeMessage mm) {
        this.fillRecipients(to, mm, Message.RecipientType.TO);
    }

    private List<Attachment> findInlineAttachments(StandardMessage sm) {
        if (sm.getAttachments() == null) {
            return null;
        }
        ArrayList<Attachment> list = new ArrayList<Attachment>();
        for (Attachment att : sm.getAttachments()) {
            if (!this.isInline(att)) continue;
            list.add(att);
        }
        return list;
    }

    private MailboxAddress findReplyTo(MimeMessage mm) {
        try {
            return this.findSingleAddress(mm.getReplyTo());
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    MailboxAddress findFromAddress(MimeMessage mm) {
        try {
            return this.findSingleAddress(mm.getFrom());
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    MailboxAddress findSingleAddress(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        return MailboxAddress.parse(addresses[0].toString());
    }

    String findContentLanguage(String[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        return arr[0];
    }

    String findSubject(MimeMessage mm) {
        try {
            return mm.getSubject();
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    String getStringContent(BodyPart bp) {
        try {
            String text;
            Object o2 = bp.getContent();
            if (o2 == null) {
                text = "";
            } else if (o2 instanceof String) {
                text = (String)o2;
            } else {
                log.warn("Unknown content type: " + o2.getClass());
                text = o2.toString();
            }
            log.debug("getStringContent: " + text);
            return text;
        }
        catch (IOException | MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    List<MailboxAddress> findRecips(MimeMessage mm, Message.RecipientType type) {
        try {
            Address[] recips = mm.getRecipients(type);
            ArrayList<MailboxAddress> list = new ArrayList<MailboxAddress>();
            if (recips != null) {
                for (Address a : recips) {
                    MailboxAddress mba = MailboxAddress.parse(a.toString());
                    list.add(mba);
                }
            }
            return list;
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public MimeMessage toMimeMessage(StandardMessage sm, Session session) {
        MimeMessage mm = new MimeMessage(session);
        this.toMimeMessage(sm, mm);
        return mm;
    }

    @Override
    public void toMimeMessage(StandardMessage sm, MimeMessage mm) {
        try {
            mm.setFrom((Address)sm.getFrom().toInternetAddress());
            mm.setSender((Address)sm.getFrom().toInternetAddress());
            this.fillReplyTo(sm, mm);
            this.fillTo(sm.getTo(), mm);
            this.fillCC(sm.getCc(), mm);
            this.fillBCC(sm.getBcc(), mm);
            mm.setSubject(sm.getSubject());
            mm.setDisposition(sm.getDisposition());
            this.fillContentLanguage(sm.getContentLanguage(), mm);
            this.fillContent(sm, (Part)mm);
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isInline(Attachment att) {
        return att.getContentId() != null && att.getContentId().length() > 2;
    }

    public static class AttachmentReadingDataSource
    implements DataSource {
        final Attachment att;

        public AttachmentReadingDataSource(Attachment att) {
            this.att = att;
        }

        public InputStream getInputStream() throws IOException {
            return this.att.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getContentType() {
            return this.att.getContentType();
        }

        public String getName() {
            return this.att.getName();
        }
    }
}

