/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail;

import io.milton.mail.Filter;
import io.milton.mail.MailResourceFactory;
import io.milton.mail.MailServer;
import io.milton.mail.pop.MinaPopServer;
import io.milton.mail.pop.PopServer;
import io.milton.mail.receive.AuthenticatedSmtpServer;
import io.milton.mail.receive.SmtpServer;
import io.milton.mail.receive.SubethaSmtpServer;
import io.milton.mail.send.AspirinMailSender;
import io.milton.mail.send.MailSender;
import java.util.List;
import org.masukomi.aspirin.core.AspirinInternal;
import org.masukomi.aspirin.core.config.Configuration;
import org.masukomi.aspirin.core.delivery.DeliveryManager;
import org.masukomi.aspirin.core.listener.ListenerManager;
import org.masukomi.aspirin.core.store.mail.FileMailStore;
import org.masukomi.aspirin.core.store.mail.MailStore;
import org.masukomi.aspirin.core.store.queue.QueueStore;
import org.masukomi.aspirin.core.store.queue.SimpleQueueStore;

public class MailServerBuilder {
    private MailResourceFactory mailResourceFactory;
    private MailSender mailSender;
    private SmtpServer smtpServer;
    private SmtpServer msaSmtpServer;
    private PopServer popServer;
    private AspirinInternal aspirinInternal;
    private Configuration aspirinConfiguration;
    private ListenerManager listenerManager;
    private DeliveryManager deliveryManager;
    private QueueStore queueStore;
    private MailStore mailStore;
    private boolean enableSender = true;
    private boolean enableSmtp = true;
    private boolean enableMsa = true;
    private boolean enablePop = false;
    private List<Filter> filters;
    private int smtpPort = 25;
    private int msaSmtpPort = 587;
    private boolean enableSmtpTls = false;
    private boolean enableMsaSmtpTls = false;

    public MailServer build() {
        if (this.mailSender == null && this.enableSender) {
            if (this.listenerManager == null) {
                this.listenerManager = new ListenerManager();
            }
            if (this.aspirinConfiguration == null) {
                this.aspirinConfiguration = new Configuration();
            }
            if (this.queueStore == null) {
                this.queueStore = new SimpleQueueStore(this.aspirinConfiguration, this.listenerManager);
            }
            if (this.mailStore == null) {
                this.mailStore = new FileMailStore(this.aspirinConfiguration);
            }
            if (this.deliveryManager == null) {
                this.deliveryManager = new DeliveryManager(this.aspirinConfiguration, this.queueStore, this.mailStore);
            }
            this.listenerManager.setDeliveryManager(this.deliveryManager);
            if (this.aspirinInternal == null) {
                this.aspirinInternal = new AspirinInternal(this.aspirinConfiguration, this.deliveryManager, this.listenerManager);
            }
            this.mailSender = new AspirinMailSender(this.aspirinInternal, this.deliveryManager, this.listenerManager);
        }
        if (this.smtpServer == null && this.enableSmtp) {
            this.smtpServer = new SubethaSmtpServer(this.smtpPort, this.enableSmtpTls, this.mailResourceFactory, this.filters);
        }
        if (this.msaSmtpServer == null && this.enableMsa) {
            this.msaSmtpServer = new AuthenticatedSmtpServer(this.msaSmtpPort, this.enableMsaSmtpTls, this.mailResourceFactory, this.mailSender, this.filters);
        }
        if (this.popServer == null && this.enablePop) {
            this.popServer = new MinaPopServer(this.mailResourceFactory, this.filters);
        }
        return new MailServer(this.mailSender, this.smtpServer, this.popServer, this.msaSmtpServer);
    }

    public MailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public SmtpServer getMsaSmtpServer() {
        return this.msaSmtpServer;
    }

    public void setMsaSmtpServer(SmtpServer msaSmtpServer) {
        this.msaSmtpServer = msaSmtpServer;
    }

    public PopServer getPopServer() {
        return this.popServer;
    }

    public void setPopServer(PopServer popServer) {
        this.popServer = popServer;
    }

    public SmtpServer getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(SmtpServer smtpServer) {
        this.smtpServer = smtpServer;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public MailResourceFactory getMailResourceFactory() {
        return this.mailResourceFactory;
    }

    public void setMailResourceFactory(MailResourceFactory mailResourceFactory) {
        this.mailResourceFactory = mailResourceFactory;
    }

    public boolean isEnableMsa() {
        return this.enableMsa;
    }

    public void setEnableMsa(boolean enableMsa) {
        this.enableMsa = enableMsa;
    }

    public boolean isEnablePop() {
        return this.enablePop;
    }

    public void setEnablePop(boolean enablePop) {
        this.enablePop = enablePop;
    }

    public boolean isEnableSender() {
        return this.enableSender;
    }

    public void setEnableSender(boolean enableSender) {
        this.enableSender = enableSender;
    }

    public boolean isEnableSmtp() {
        return this.enableSmtp;
    }

    public void setEnableSmtp(boolean enableSmtp) {
        this.enableSmtp = enableSmtp;
    }

    public Configuration getAspirinConfiguration() {
        return this.aspirinConfiguration;
    }

    public void setAspirinConfiguration(Configuration aspirinConfiguration) {
        this.aspirinConfiguration = aspirinConfiguration;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public boolean isEnableSmtpTls() {
        return this.enableSmtpTls;
    }

    public void setEnableSmtpTls(boolean enableSmtpTls) {
        this.enableSmtpTls = enableSmtpTls;
    }

    public int getMsaSmtpPort() {
        return this.msaSmtpPort;
    }

    public void setMsaSmtpPort(int msaSmtpPort) {
        this.msaSmtpPort = msaSmtpPort;
    }

    public boolean isEnableMsaSmtpTls() {
        return this.enableMsaSmtpTls;
    }

    public void setEnableMsaSmtpTls(boolean enableMsaSmtpTls) {
        this.enableMsaSmtpTls = enableMsaSmtpTls;
    }

    public MailStore getMailStore() {
        return this.mailStore;
    }

    public void setMailStore(MailStore mailStore) {
        this.mailStore = mailStore;
    }

    public QueueStore getQueueStore() {
        return this.queueStore;
    }

    public void setQueueStore(QueueStore queueStore) {
        this.queueStore = queueStore;
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public void setListenerManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    public AspirinInternal getAspirinInternal() {
        return this.aspirinInternal;
    }

    public void setAspirinInternal(AspirinInternal aspirinInternal) {
        this.aspirinInternal = aspirinInternal;
    }

    public DeliveryManager getDeliveryManager() {
        return this.deliveryManager;
    }

    public void setDeliveryManager(DeliveryManager deliveryManager) {
        this.deliveryManager = deliveryManager;
    }
}

