/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail.pop;

import io.milton.mail.Filter;
import io.milton.mail.MailResourceFactory;
import io.milton.mail.pop.PopIOHandlerAdapter;
import io.milton.mail.pop.PopServer;
import io.milton.mail.pop.PopSession;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.buffer.IoBufferAllocator;
import org.apache.mina.core.buffer.SimpleBufferAllocator;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.stream.StreamWriteFilter;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaPopServer
implements PopServer {
    private static final Logger log = LoggerFactory.getLogger(MinaPopServer.class);
    private SocketAcceptor acceptor;
    private int popPort;
    private MailResourceFactory resourceFactory;
    private final List<Filter> filters;

    public MinaPopServer(MailResourceFactory resourceFactory, List<Filter> filters) {
        this(110, resourceFactory, filters);
    }

    public MinaPopServer(int popPort, MailResourceFactory resourceFactory, List<Filter> filters) {
        this.popPort = popPort;
        this.resourceFactory = resourceFactory;
        this.filters = filters;
    }

    public MinaPopServer(int popPort, MailResourceFactory resourceFactory, Filter filter) {
        this(popPort, resourceFactory, Collections.singletonList(filter));
    }

    @Override
    public void start() {
        IoBuffer.setUseDirectBuffer((boolean)false);
        IoBuffer.setAllocator((IoBufferAllocator)new SimpleBufferAllocator());
        this.acceptor = new NioSocketAcceptor();
        this.acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory(Charset.forName("US-ASCII"))));
        this.acceptor.getFilterChain().addLast("stream", (IoFilter)new StreamWriteFilter());
        this.acceptor.setHandler((IoHandler)new PopIOHandlerAdapter(this.resourceFactory, this.filters));
        try {
            this.acceptor.bind((SocketAddress)new InetSocketAddress(this.popPort));
        }
        catch (IOException ex) {
            throw new RuntimeException("Couldnt bind to port: " + this.popPort, ex);
        }
    }

    @Override
    public void stop() {
        this.acceptor.unbind();
        this.acceptor = null;
    }

    @Override
    public int getPopPort() {
        return this.popPort;
    }

    public void setPopPort(int popPort) {
        this.popPort = popPort;
    }

    public MailResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public void setResourceFactory(MailResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    static PopSession sess(IoSession session) {
        return (PopSession)session.getAttribute((Object)"stateMachine");
    }
}

