/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail.pop;

import io.milton.mail.Event;
import io.milton.mail.Filter;
import io.milton.mail.FilterChain;
import io.milton.mail.MailResourceFactory;
import io.milton.mail.pop.MinaPopServer;
import io.milton.mail.pop.PopMessageEvent;
import io.milton.mail.pop.PopSession;
import java.util.List;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopIOHandlerAdapter
extends IoHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(PopIOHandlerAdapter.class);
    private final MailResourceFactory resourceFactory;
    private final List<Filter> filters;

    public PopIOHandlerAdapter(MailResourceFactory resourceFactory, List<Filter> filters) {
        this.resourceFactory = resourceFactory;
        this.filters = filters;
    }

    public void exceptionCaught(IoSession session, Throwable t) throws Exception {
        t.printStackTrace();
        session.close();
    }

    public void messageReceived(IoSession session, Object msg) throws Exception {
        log.info("pop message: " + msg);
        PopMessageEvent event = new PopMessageEvent(session, msg);
        Filter terminal = (chain, event1) -> MinaPopServer.sess(session).messageReceived(session, msg);
        FilterChain chain2 = new FilterChain(this.filters, terminal);
        chain2.doEvent((Event)event);
    }

    public void sessionCreated(IoSession session) throws Exception {
        log.info("Session created...");
        ((SocketSessionConfig)session.getConfig()).setReceiveBufferSize(2048);
        session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, 10);
        PopSession sess = new PopSession(session, this.resourceFactory);
        session.setAttribute((Object)"stateMachine", (Object)sess);
    }
}

