/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail.receive;

import io.milton.mail.AcceptEvent;
import io.milton.mail.DeliverEvent;
import io.milton.mail.Event;
import io.milton.mail.Filter;
import io.milton.mail.FilterChain;
import io.milton.mail.LoginEvent;
import io.milton.mail.MailResourceFactory;
import io.milton.mail.Mailbox;
import io.milton.mail.MailboxAddress;
import io.milton.mail.receive.SubethaSmtpServer;
import io.milton.mail.send.MailSender;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.auth.LoginAuthenticationHandler;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.PlainAuthenticationHandler;
import org.subethamail.smtp.auth.PluginAuthenticationHandler;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.server.MessageListenerAdapter;

public class AuthenticatedSmtpServer
extends SubethaSmtpServer {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatedSmtpServer.class);
    private final MailSender mailSender;

    public AuthenticatedSmtpServer(int smtpPort, boolean enableTls, MailResourceFactory resourceFactory, MailSender mailSender, List<Filter> filters) {
        super(smtpPort, enableTls, resourceFactory, filters);
        this.mailSender = mailSender;
    }

    public AuthenticatedSmtpServer(MailResourceFactory resourceFactory, MailSender mailSender, List<Filter> filters) {
        super(587, false, resourceFactory, filters);
        this.mailSender = mailSender;
    }

    @Override
    protected void initSmtpReceiver() {
        super.initSmtpReceiver();
        MessageListenerAdapter mla = (MessageListenerAdapter)this.smtpReceivingServer.getMessageHandlerFactory();
        mla.setAuthenticationHandlerFactory((AuthenticationHandlerFactory)new AuthHandlerFactory());
    }

    public void sendMail(MimeMessage mm) {
        this.mailSender.sendMail(mm);
    }

    public void sendMail(String fromAddress, String fromPersonal, List<String> to, String replyTo, String subject, String text) {
        this.mailSender.sendMail(fromAddress, fromPersonal, to, replyTo, subject, text);
    }

    public Session getSmtpSendSession() {
        return this.mailSender.getSession();
    }

    @Override
    public boolean accept(String sFrom, String sRecipient) {
        log.debug("accept? " + sFrom + " - " + sRecipient);
        if (sFrom == null || sFrom.length() == 0) {
            log.error("Cannot accept email with no from address. Recipient is: " + sRecipient);
            return false;
        }
        AcceptEvent event = new AcceptEvent(sFrom, sRecipient);
        Filter terminal = (chain, e) -> {
            MailboxAddress from = MailboxAddress.parse((String)event.getFrom());
            Mailbox fromMailbox = this.resourceFactory.getMailbox(from);
            if (fromMailbox != null && !fromMailbox.isEmailDisabled()) {
                event.setAccept(true);
                return;
            }
            MailboxAddress recip = MailboxAddress.parse((String)event.getRecipient());
            Mailbox recipMailbox = this.resourceFactory.getMailbox(recip);
            boolean b = recipMailbox != null && !recipMailbox.isEmailDisabled();
            log.debug("accept email from: " + event.getFrom() + " to: " + event.getRecipient() + "?" + b);
            event.setAccept(b);
        };
        FilterChain chain2 = new FilterChain(this.filters, terminal);
        chain2.doEvent((Event)event);
        return event.isAccept();
    }

    @Override
    public void deliver(String sFrom, String sRecipient, InputStream data) throws IOException {
        log.debug("deliver email from: " + sFrom + " to: " + sRecipient);
        log.debug("email from: " + sFrom + " to: " + sRecipient);
        DeliverEvent event = new DeliverEvent(sFrom, sRecipient, data);
        Filter terminal = (chain, e) -> {
            MailboxAddress from = MailboxAddress.parse((String)event.getFrom());
            MailboxAddress recip = MailboxAddress.parse((String)event.getRecipient());
            MimeMessage mm = this.parseInput(data);
            Mailbox recipMailbox = this.resourceFactory.getMailbox(recip);
            if (recipMailbox != null && !recipMailbox.isEmailDisabled()) {
                log.debug("recipient is known to us, so store: " + recip);
                this.storeMail(recipMailbox, mm);
            } else {
                Mailbox fromMailbox = this.resourceFactory.getMailbox(from);
                if (fromMailbox != null && !fromMailbox.isEmailDisabled()) {
                    log.debug("known from address, so will transmit: from: " + from);
                    this.mailSender.sendMail(mm);
                } else {
                    throw new NullPointerException("Neither from address nor recipient are known to us. Will not store or send: from: " + event.getFrom() + " to: " + event.getRecipient());
                }
            }
        };
        FilterChain chain2 = new FilterChain(this.filters, terminal);
        chain2.doEvent((Event)event);
    }

    @Override
    protected Session getSession() {
        return this.mailSender.getSession();
    }

    public boolean doLogin(String username, String password) {
        LoginEvent event = new LoginEvent(username, password);
        Filter terminal = (chain, e) -> event.setLoginSuccessful(this._doLogin(event.getUsername(), event.getPassword()));
        FilterChain chain2 = new FilterChain(this.filters, terminal);
        chain2.doEvent((Event)event);
        return event.isLoginSuccessful();
    }

    public boolean _doLogin(String username, String password) {
        try {
            MailboxAddress userName = MailboxAddress.parse((String)username);
            Mailbox mbox = this.resourceFactory.getMailbox(userName);
            if (mbox == null) {
                log.debug("user not found");
                return false;
            }
            if (!mbox.authenticate(password)) {
                log.debug("authentication failed");
                return false;
            }
            return true;
        }
        catch (IllegalArgumentException ex) {
            log.debug("username could not be parsed. use form user@domain.com");
            return false;
        }
    }

    public MailSender getMailSender() {
        return this.mailSender;
    }

    public class AuthHandlerFactory
    implements AuthenticationHandlerFactory {
        public AuthenticationHandler create() {
            PluginAuthenticationHandler ret = new PluginAuthenticationHandler();
            UsernamePasswordValidator validator = (username, password) -> {
                boolean loginOk = AuthenticatedSmtpServer.this.doLogin(username, password);
                if (!loginOk) {
                    throw new LoginFailedException("authentication failed");
                }
            };
            ret.addPlugin((AuthenticationHandler)new PlainAuthenticationHandler(validator));
            ret.addPlugin((AuthenticationHandler)new LoginAuthenticationHandler(validator));
            return ret;
        }
    }
}

