/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail.send;

import io.milton.mail.StandardMessage;
import io.milton.mail.StandardMessageFactoryImpl;
import io.milton.mail.send.MailSender;
import io.milton.mail.send.MySmtpMessage;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.masukomi.aspirin.core.AspirinInternal;
import org.masukomi.aspirin.core.delivery.DeliveryManager;
import org.masukomi.aspirin.core.listener.AspirinListener;
import org.masukomi.aspirin.core.listener.ListenerManager;
import org.masukomi.aspirin.core.listener.ResultState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspirinMailSender
implements MailSender,
AspirinListener {
    private static final Logger log = LoggerFactory.getLogger(AspirinMailSender.class);
    private final AspirinInternal aspirin;
    private final ListenerManager listenerManager;
    private final DeliveryManager deliveryManager;
    private boolean started;

    public AspirinMailSender(AspirinInternal aspirinInternal, DeliveryManager deliveryManager, ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
        this.deliveryManager = deliveryManager;
        this.aspirin = aspirinInternal;
    }

    @Override
    public void sendMail(MimeMessage mm) {
        if (!this.started) {
            throw new RuntimeException("This mail sender is stopped");
        }
        try {
            this.aspirin.add(mm, -1L);
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void sendMail(String from, String fromPersonal, List<String> to, String replyTo, String subject, String text) {
        if (!this.started) {
            throw new RuntimeException("This mail sender is stopped");
        }
        try {
            MimeMessage mm = new MimeMessage(this.getSession());
            mm.setSubject(subject);
            mm.setFrom((Address)new InternetAddress(from, fromPersonal));
            Address[] add = new Address[]{new InternetAddress(replyTo)};
            mm.setReplyTo(add);
            for (String sTo : to) {
                mm.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(sTo));
            }
            mm.setContent((Object)text, "text/plain");
            this.sendMail(mm);
        }
        catch (UnsupportedEncodingException | MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Session getSession() {
        Properties props = new Properties();
        return Session.getInstance((Properties)props);
    }

    @Override
    public MimeMessage newMessage(MimeMessage mm) {
        try {
            return new MySmtpMessage(this.getSession(), mm);
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public MimeMessage newMessage() {
        return new MimeMessage(this.getSession());
    }

    @Override
    public void start() {
        this.started = true;
        this.listenerManager.add((AspirinListener)this);
        this.aspirin.start();
    }

    @Override
    public void stop() {
        this.started = false;
        this.listenerManager.remove((AspirinListener)this);
        this.deliveryManager.shutdown();
        this.aspirin.shutdown();
    }

    @Override
    public void sendMail(StandardMessage sm) {
        StandardMessageFactoryImpl smf = new StandardMessageFactoryImpl();
        MimeMessage mm = this.newMessage();
        smf.toMimeMessage(sm, mm);
        this.sendMail(mm);
    }

    public void delivered(String mailId, String recipient, ResultState state, String resultContent) {
        log.info("delivered: " + recipient + " state: " + state + " result: " + resultContent);
    }
}

