/*
 * Decompiled with CFR 0.152.
 */
package io.milton.grizzly;

import io.milton.grizzly.MiltonGrizzlyMultipartUploader;
import io.milton.http.AbstractRequest;
import io.milton.http.Auth;
import io.milton.http.BeanCookie;
import io.milton.http.Cookie;
import io.milton.http.Request;
import io.milton.http.RequestParseException;
import io.milton.http.Response;
import io.milton.servlet.FileItemWrapper;
import io.milton.servlet.upload.MonitoredDiskFileItemFactory;
import io.milton.servlet.upload.UploadListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.glassfish.grizzly.http.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyMiltonRequest
extends AbstractRequest {
    private static final Logger log = LoggerFactory.getLogger(GrizzlyMiltonRequest.class);
    private static final Map<Response.ContentType, String> contentTypes = new EnumMap<Response.ContentType, String>(Response.ContentType.class);
    private static final Map<String, Response.ContentType> typeContents = new HashMap<String, Response.ContentType>();
    private final Request wrapped;
    private Auth auth;
    private Map<String, String> mapOfHeaders;

    public static BeanCookie toBeanCookie(org.glassfish.grizzly.http.Cookie c) {
        BeanCookie bc = new BeanCookie(c.getName());
        bc.setDomain(c.getDomain());
        bc.setExpiry(c.getMaxAge());
        bc.setHttpOnly(true);
        bc.setPath(c.getPath());
        bc.setSecure(c.isSecure());
        bc.setValue(c.getValue());
        bc.setVersion(c.getVersion());
        return bc;
    }

    public GrizzlyMiltonRequest(Request wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public String getHostHeader() {
        String s = this.getRequestHeader(Request.Header.HOST);
        if (s == null) {
            s = "";
        }
        return s;
    }

    @Override
    public String getRequestHeader(Request.Header header) {
        return this.wrapped.getHeader(header.code);
    }

    public Map<String, String> getHeaders() {
        if (this.mapOfHeaders == null) {
            this.mapOfHeaders = new HashMap<String, String>();
            for (String headerName : this.wrapped.getHeaderNames()) {
                String s = this.wrapped.getHeader(headerName);
                this.mapOfHeaders.put(headerName, s);
            }
        }
        return this.mapOfHeaders;
    }

    public String getFromAddress() {
        return this.wrapped.getRemoteHost();
    }

    public Request.Method getMethod() {
        return Request.Method.valueOf((String)this.wrapped.getMethod().getMethodString());
    }

    public Auth getAuthorization() {
        if (this.auth != null) {
            return this.auth;
        }
        String enc = this.getRequestHeader(Request.Header.AUTHORIZATION);
        if (enc == null) {
            log.trace("getAuthorization: No http credentials in request headers");
            return null;
        }
        if (enc.length() == 0) {
            log.trace("getAuthorization: No http credentials in request headers; authorization header is not-null, but is empty");
            return null;
        }
        this.auth = new Auth(enc);
        if (log.isTraceEnabled()) {
            log.trace("creating new auth object {}", (Object)this.auth.getScheme());
        }
        return this.auth;
    }

    public void setAuthorization(Auth auth) {
        this.auth = auth;
    }

    public String getAbsoluteUrl() {
        return this.wrapped.getRequestURL().toString();
    }

    @Override
    public String getAbsolutePath() {
        return this.wrapped.getRequestURI();
    }

    public InputStream getInputStream() throws IOException {
        return this.wrapped.getInputStream();
    }

    public void parseRequestParameters(Map<String, String> params, Map<String, io.milton.http.FileItem> files) throws RequestParseException {
        try {
            if (this.isMultiPartMixed()) {
                UploadListener listener = new UploadListener();
                MonitoredDiskFileItemFactory factory = new MonitoredDiskFileItemFactory(listener);
                this.parseQueryString(params);
                MiltonGrizzlyMultipartUploader mgms = new MiltonGrizzlyMultipartUploader(params, files, (FileItemFactory)factory);
                mgms.parseRequest(this.wrapped);
            } else if (this.isMultiPart()) {
                log.trace("parseRequestParameters: isMultiPart");
                UploadListener listener = new UploadListener();
                MonitoredDiskFileItemFactory factory = new MonitoredDiskFileItemFactory(listener);
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                List items = upload.parseRequest(new RequestContext(){

                    public String getCharacterEncoding() {
                        String s = GrizzlyMiltonRequest.this.wrapped.getCharacterEncoding();
                        if (s == null) {
                            s = StandardCharsets.UTF_8.name();
                        }
                        return s;
                    }

                    public String getContentType() {
                        String s = GrizzlyMiltonRequest.this.wrapped.getContentType();
                        if (s == null) {
                            s = StandardCharsets.UTF_8.name();
                        }
                        return s;
                    }

                    public int getContentLength() {
                        return GrizzlyMiltonRequest.this.wrapped.getContentLength();
                    }

                    public InputStream getInputStream() throws IOException {
                        return GrizzlyMiltonRequest.this.wrapped.getInputStream();
                    }
                });
                this.parseQueryString(params);
                for (Object o : items) {
                    FileItem item = (FileItem)o;
                    if (item.isFormField()) {
                        String val = item.getContentType() != null ? item.getString() : item.getString("UTF-8");
                        params.put(item.getFieldName(), val);
                        continue;
                    }
                    String itemKey = item.getFieldName();
                    if (files.containsKey(itemKey)) {
                        int count = 1;
                        while (files.containsKey(itemKey + count)) {
                            ++count;
                        }
                        itemKey = itemKey + count;
                    }
                    files.put(itemKey, new FileItemWrapper(item));
                }
            } else {
                for (String nm : this.wrapped.getParameterNames()) {
                    String[] vals = this.wrapped.getParameterValues(nm);
                    if (vals.length == 1) {
                        params.put(nm, vals[0]);
                        continue;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (String s : vals) {
                        sb.append(s).append(",");
                    }
                    if (sb.length() > 0) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    params.put(nm, sb.toString());
                }
            }
        }
        catch (FileUploadException ex) {
            throw new RequestParseException("FileUploadException", (Throwable)ex);
        }
        catch (Throwable ex) {
            throw new RequestParseException(ex.getMessage(), ex);
        }
    }

    public Cookie getCookie(String name) {
        if (this.wrapped.getCookies() != null) {
            for (org.glassfish.grizzly.http.Cookie c : this.wrapped.getCookies()) {
                if (!c.getName().equals(name)) continue;
                return GrizzlyMiltonRequest.toBeanCookie(c);
            }
        }
        return null;
    }

    public List<Cookie> getCookies() {
        ArrayList<Cookie> list = new ArrayList<Cookie>();
        if (this.wrapped.getCookies() != null) {
            for (org.glassfish.grizzly.http.Cookie c : this.wrapped.getCookies()) {
                list.add((Cookie)GrizzlyMiltonRequest.toBeanCookie(c));
            }
        }
        return list;
    }

    public String getRemoteAddr() {
        String forewardFor = this.wrapped.getHeader("X-Forwarded-For");
        if (StringUtils.isNotBlank((String)forewardFor)) {
            return forewardFor;
        }
        forewardFor = this.wrapped.getHeader("x-forwarded-for");
        if (StringUtils.isNotBlank((String)forewardFor)) {
            return forewardFor;
        }
        return this.wrapped.getRemoteAddr();
    }

    private void parseQueryString(Map<String, String> map) {
        String qs = this.wrapped.getQueryString();
        GrizzlyMiltonRequest.parseQueryString(map, qs);
    }

    public static void parseQueryString(Map<String, String> map, String qs) {
        String[] nvs;
        if (qs == null) {
            return;
        }
        for (String nv : nvs = qs.split("&")) {
            String[] parts = nv.split("=");
            String key = parts[0];
            String val = null;
            if (parts.length > 1) {
                val = parts[1];
            }
            if (val != null) {
                try {
                    val = URLDecoder.decode(val, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
            }
            map.put(key, val);
        }
    }

    protected boolean isMultiPart() {
        Response.ContentType ct = this.getRequestContentType();
        return Response.ContentType.MULTIPART.equals((Object)ct);
    }

    protected boolean isMultiPartMixed() {
        Response.ContentType ct = this.getRequestContentType();
        return Response.ContentType.MULTIPART_MIXED.equals((Object)ct);
    }

    protected Response.ContentType getRequestContentType() {
        String s = this.wrapped.getContentType();
        log.trace("request content type", (Object)s);
        if (s == null) {
            return null;
        }
        if (s.contains("multipart/mixed")) {
            return Response.ContentType.MULTIPART_MIXED;
        }
        if (s.contains("multipart/form-data")) {
            return Response.ContentType.MULTIPART;
        }
        return typeContents.get(s);
    }

    static {
        contentTypes.put(Response.ContentType.HTTP, "text/html");
        contentTypes.put(Response.ContentType.MULTIPART, "multipart/form-data");
        contentTypes.put(Response.ContentType.XML, "text/xml; charset=UTF-8");
        for (Response.ContentType key : contentTypes.keySet()) {
            typeContents.put(contentTypes.get(key), key);
        }
    }
}

