/*
 * Decompiled with CFR 0.152.
 */
package io.milton.grizzly;

import io.milton.grizzly.GrizzlyServer;
import io.milton.grizzly.MiltonSNICertificateStore;
import io.milton.grizzly.MiltonSNICertificateStoreSpi;
import io.milton.grizzly.SSLTools;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiltonSNICertificateManager {
    private static final Logger log = LoggerFactory.getLogger(MiltonSNICertificateManager.class);
    public static final String SECURE_TYPE = "TLS";
    public static final String SYS_SECURE_PROTOCOL = "secure.protocol";
    public final String primaryDomain;
    private static MiltonSNICertificateManager sniCerManager;
    private final MiltonSNICertificateStoreSpi keyStoreSpi;
    private final MiltonSNICertificateStore certificateStore;

    public MiltonSNICertificateManager(MiltonSNICertificateStore store) {
        this.certificateStore = store;
        this.keyStoreSpi = new MiltonSNICertificateStoreSpi(this.certificateStore);
        this.primaryDomain = GrizzlyServer.getPropertyOrDefault("secure.primary_domain", "localhost");
    }

    public KeyManager[] createKeyManager() {
        return new SNICertificateManager[]{new SNICertificateManager()};
    }

    public SSLEngineConfigurator createEngineConfigurator() {
        return this.createEngineConfigurator(this.createKeyManager());
    }

    public SSLEngineConfigurator createEngineConfigurator(KeyManager[] keyManager) {
        try {
            String protocol = GrizzlyServer.getPropertyOrDefault(SYS_SECURE_PROTOCOL, SECURE_TYPE);
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(keyManager, null, new SecureRandom());
            return new SSLEngineConfigurator(sslContext, false, false, false);
        }
        catch (Exception ex) {
            log.error("createSSLContext", (Throwable)ex);
            return null;
        }
    }

    protected class SNICertificateManager
    extends X509ExtendedKeyManager {
        protected SNICertificateManager() {
        }

        @Override
        public X509Certificate[] getCertificateChain(String domainName) {
            log.trace("Get the CertificateChain for the domain {}", (Object)domainName);
            Object[] cer = domainName.endsWith("admin." + MiltonSNICertificateManager.this.primaryDomain) ? this.loadCertificatesFromLocalFile() : MiltonSNICertificateManager.this.keyStoreSpi.engineGetCertificateChain(domainName);
            if (log.isDebugEnabled()) {
                log.debug("the Certificate Chain is :", (Object)Arrays.toString(cer));
            }
            return cer;
        }

        @Override
        public PrivateKey getPrivateKey(String domainName) {
            log.trace("Get the PrivateKey for the domain : {}", (Object)domainName);
            PrivateKey pk = null;
            if (domainName.endsWith("admin." + MiltonSNICertificateManager.this.primaryDomain)) {
                try {
                    pk = this.loadPrivateKeyFromFile();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                pk = (PrivateKey)MiltonSNICertificateManager.this.keyStoreSpi.engineGetKey(domainName, null);
            }
            log.trace("Retrieved PK: {}", (Object)pk);
            return pk;
        }

        private PrivateKey loadPrivateKeyFromFile() throws IOException, GeneralSecurityException {
            String filePath = GrizzlyServer.getPropertyOrDefault("secure.privatekey", null);
            if (StringUtils.isNotBlank((String)filePath)) {
                File file = new File(filePath).getAbsoluteFile();
                byte[] certBytes = FileUtils.readFileToByteArray((File)file);
                return SSLTools.parsePrivateKey(certBytes);
            }
            return null;
        }

        private X509Certificate[] loadCertificatesFromLocalFile() {
            try {
                List<File> certFiles = this.getCertificateFiles();
                ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
                for (File certFile : certFiles) {
                    byte[] certBytes;
                    X509Certificate cert;
                    if (!certFile.isFile() || !certFile.exists() || (cert = SSLTools.parseX509Certificate(certBytes = FileUtils.readFileToByteArray((File)certFile))) == null) continue;
                    certificates.add(cert);
                }
                X509Certificate[] xcf = new X509Certificate[certificates.size()];
                certificates.toArray(xcf);
                log.trace("loaded X509Certificate[] len = {}", (Object)xcf.length);
                return xcf;
            }
            catch (Exception ex) {
                log.error("getCertificate error.", (Throwable)ex);
                return null;
            }
        }

        private List<File> getCertificateFiles() throws URISyntaxException {
            String[] certParts;
            ArrayList<File> certificate = new ArrayList<File>();
            String pathToCerts = GrizzlyServer.getPropertyOrDefault("secure.certificate", null);
            for (String certPath : certParts = pathToCerts.split(",")) {
                File certFile = new File(certPath);
                certificate.add(certFile);
            }
            return certificate;
        }

        @Override
        public String chooseEngineServerAlias(String type, Principal[] issuers, SSLEngine engine) {
            log.trace("Https (SSL/TLS) Handshaking start....");
            log.trace("Choose the EngineServer Alias Name, and the engine type is: {}", (Object)type);
            ExtendedSSLSession handshakeSession = (ExtendedSSLSession)engine.getHandshakeSession();
            log.debug("Choose EngineServer Alias Name, and the handshake session is:" + handshakeSession.hashCode());
            String domainName = null;
            for (SNIServerName name : handshakeSession.getRequestedServerNames()) {
                if (name.getType() != 0) continue;
                domainName = ((SNIHostName)name).getAsciiName();
                break;
            }
            log.trace("chooseEngineServerAlias, SNIServerName is: {}", domainName);
            boolean hostNameCheck = MiltonSNICertificateManager.this.keyStoreSpi.engineContainsAlias(domainName);
            if (hostNameCheck) {
                return domainName;
            }
            return null;
        }

        @Override
        public String[] getClientAliases(String alias, Principal[] prncpls) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String chooseClientAlias(String[] alias, Principal[] prncpls, Socket socket) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String chooseEngineClientAlias(String[] alias, Principal[] issuers, SSLEngine engine) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String[] getServerAliases(String string, Principal[] prncpls) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String chooseServerAlias(String string, Principal[] prncpls, Socket socket) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

