/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.common.BufferingOutputStream;
import io.milton.common.FileUtils;
import io.milton.http.AbstractWrappingResponseHandler;
import io.milton.http.Auth;
import io.milton.http.CompressedResource;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.entity.CompressedResourceEntity;
import io.milton.http.entity.InputStreamEntity;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.CacheControlHelper;
import io.milton.http.http11.DefaultCacheControlHelper;
import io.milton.http.http11.DefaultHttp11ResponseHandler;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressingResponseHandler
extends AbstractWrappingResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(CompressingResponseHandler.class);
    private int maxMemorySize = 100000;
    private CacheControlHelper cacheControlHelper = new DefaultCacheControlHelper();

    public CompressingResponseHandler() {
    }

    public CompressingResponseHandler(WebDavResponseHandler wrapped) {
        super(wrapped);
    }

    public CacheControlHelper getCacheControlHelper() {
        return this.cacheControlHelper;
    }

    public void setCacheControlHelper(CacheControlHelper cacheControlHelper) {
        this.cacheControlHelper = cacheControlHelper;
    }

    @Override
    public void respondContent(Resource resource, Response response, Request request, Map<String, String> params) throws NotAuthorizedException, BadRequestException, NotFoundException {
        if (resource instanceof GetableResource) {
            CompressedResource compressedResource;
            String acceptableEncoding;
            GetableResource r = (GetableResource)resource;
            String acceptableContentTypes = request.getAcceptHeader();
            String contentType = r.getContentType(acceptableContentTypes);
            String acceptableEncodings = request.getAcceptEncodingHeader();
            if (r instanceof CompressedResource && (acceptableEncoding = (compressedResource = (CompressedResource)r).getSupportedEncoding(acceptableEncodings)) != null) {
                response.setContentTypeHeader(contentType);
                this.cacheControlHelper.setCacheControl(r, response, request.getAuthorization());
                Long contentLength = compressedResource.getCompressedContentLength(acceptableEncoding);
                response.setContentLengthHeader(contentLength);
                response.setContentEncodingHeader(Response.ContentEncoding.GZIP);
                response.setVaryHeader("Accept-Encoding");
                response.setEntity((Response.Entity)new CompressedResourceEntity(compressedResource, params, contentType, acceptableEncoding));
                return;
            }
            if (this.canCompress(r, contentType, acceptableEncodings)) {
                log.trace("respondContent: compressable");
                BufferingOutputStream tempOut = new BufferingOutputStream(this.maxMemorySize);
                try {
                    GZIPOutputStream gzipOut = new GZIPOutputStream((OutputStream)tempOut);
                    r.sendContent((OutputStream)gzipOut, null, params, contentType);
                    ((OutputStream)gzipOut).flush();
                    ((OutputStream)gzipOut).close();
                    tempOut.flush();
                }
                catch (NotFoundException e) {
                    tempOut.deleteTempFileIfExists();
                    throw e;
                }
                catch (IOException ex) {
                    tempOut.deleteTempFileIfExists();
                    throw new RuntimeException(ex);
                }
                finally {
                    FileUtils.close((Closeable)tempOut);
                }
                log.trace("respondContent-compressed: " + resource.getClass());
                this.setRespondContentCommonHeaders(response, resource, Response.Status.SC_OK, request.getAuthorization());
                response.setContentEncodingHeader(Response.ContentEncoding.GZIP);
                response.setVaryHeader("Accept-Encoding");
                long contentLength = tempOut.getSize();
                response.setContentLengthHeader(Long.valueOf(contentLength));
                response.setContentTypeHeader(contentType);
                this.cacheControlHelper.setCacheControl(r, response, request.getAuthorization());
                response.setEntity((Response.Entity)new InputStreamEntity(tempOut.getInputStream()));
            } else {
                log.trace("respondContent: not compressable");
                this.wrapped.respondContent(resource, response, request, params);
            }
        } else {
            throw new RuntimeException("Cant generate content for non-Getable resource: " + resource.getClass());
        }
    }

    protected void setRespondContentCommonHeaders(Response response, Resource resource, Response.Status status, Auth auth) {
        response.setDateHeader(new Date());
        if (response.getStatus() == null || response.getStatus().code == 200) {
            response.setStatus(status);
            String etag = this.wrapped.generateEtag(resource);
            if (etag != null) {
                response.setEtag(etag);
            }
            DefaultHttp11ResponseHandler.setModifiedDate(response, resource, auth);
        }
    }

    private boolean canCompress(GetableResource r, String contentType, String acceptableEncodings) {
        log.trace("canCompress: contentType: " + contentType + " acceptable-encodings: " + acceptableEncodings);
        if (contentType != null) {
            boolean contentIsCompressable;
            boolean bl = contentIsCompressable = (contentType = contentType.toLowerCase()).contains("text") || contentType.contains("css") || contentType.contains("js") || contentType.contains("javascript");
            if (contentIsCompressable) {
                boolean supportsGzip = acceptableEncodings != null && acceptableEncodings.toLowerCase().contains("gzip");
                log.trace("supports gzip: " + supportsGzip);
                return supportsGzip;
            }
        }
        return false;
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    public int getMaxMemorySize() {
        return this.maxMemorySize;
    }
}

