/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.common.Stoppable;
import io.milton.common.Utils;
import io.milton.event.Event;
import io.milton.event.EventManager;
import io.milton.event.RequestEvent;
import io.milton.event.ResponseEvent;
import io.milton.http.EventListener;
import io.milton.http.FileItem;
import io.milton.http.Filter;
import io.milton.http.FilterChain;
import io.milton.http.Handler;
import io.milton.http.HttpExtension;
import io.milton.http.ProtocolHandlers;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.http.Response;
import io.milton.http.entity.EntityTransport;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.http11.CustomPostHandler;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpManager {
    private static final Logger log = LoggerFactory.getLogger(HttpManager.class);
    private static final ThreadLocal<Request> tlRequest = new ThreadLocal();
    private static final ThreadLocal<Response> tlResponse = new ThreadLocal();
    private static final Map<Thread, RequestInfo> mapOfRequestsByThread = new ConcurrentHashMap<Thread, RequestInfo>();
    private final ProtocolHandlers handlers;
    private final List<Filter> filters;
    private final List<EventListener> eventListeners = new ArrayList<EventListener>();
    private final ResourceFactory resourceFactory;
    private final Http11ResponseHandler responseHandler;
    private final EventManager eventManager;
    private final List<Stoppable> shutdownHandlers;
    private final EntityTransport entityTransport;
    private Map<String, Handler> methodHandlers;

    public static RequestInfo getRequestDataForThread(Thread th) {
        return mapOfRequestsByThread.get(th);
    }

    public static String decodeUrl(String s) {
        return Utils.decodePath((String)s);
    }

    public static Request request() {
        return tlRequest.get();
    }

    public static Response response() {
        return tlResponse.get();
    }

    public HttpManager(ResourceFactory resourceFactory, WebDavResponseHandler responseHandler, ProtocolHandlers handlers, EntityTransport entityTransport, List<Filter> filters, EventManager eventManager, List<Stoppable> shutdownHandlers) {
        this.responseHandler = responseHandler;
        this.handlers = handlers;
        this.resourceFactory = resourceFactory;
        this.entityTransport = entityTransport;
        this.filters = filters;
        this.eventManager = eventManager;
        this.shutdownHandlers = shutdownHandlers;
        this.initHandlers();
    }

    private void initHandlers() {
        this.methodHandlers = new ConcurrentHashMap<String, Handler>();
        for (HttpExtension ext : this.handlers) {
            for (Handler h : ext.getHandlers()) {
                for (String m : h.getMethods()) {
                    this.methodHandlers.put(m, h);
                }
            }
        }
    }

    public void sendResponseEntity(Response response) throws Exception {
        this.entityTransport.sendResponseEntity(response);
    }

    public void closeResponse(Response response) {
        this.entityTransport.closeResponse(response);
    }

    public Handler getMethodHandler(Request.Method m) {
        return this.methodHandlers.get(m.code);
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Request request, Response response) {
        if (request == null) {
            throw new RuntimeException("request is null");
        }
        String host = request.getHostHeader();
        if (host == null) {
            host = "";
        }
        if (log.isInfoEnabled()) {
            log.info(request.getMethod() + " :: " + host + "//" + request.getAbsolutePath() + " start");
        }
        try {
            this.setThreadAffinityData(request, response);
            try {
                this.fireRequestEvent(request);
            }
            catch (ConflictException ex) {
                this.responseHandler.respondConflict(null, response, request, null);
            }
            catch (BadRequestException ex) {
                this.responseHandler.respondBadRequest(null, response, request);
            }
            catch (NotAuthorizedException ex) {
                this.responseHandler.respondUnauthorised(null, response, request);
            }
            FilterChain chain = new FilterChain(this);
            long tm = System.currentTimeMillis();
            chain.process(request, response);
            try {
                tm = System.currentTimeMillis() - tm;
                if (log.isInfoEnabled()) {
                    log.info(request.getMethod() + " :: " + host + "//" + request.getAbsolutePath() + " finished " + tm + "ms, Status:" + response.getStatus() + ", Length:" + response.getContentLength());
                }
                this.fireResponseEvent(request, response, tm);
            }
            catch (ConflictException ex) {
                log.warn("exception thrown from event handler after response is complete", (Throwable)ex);
            }
            catch (BadRequestException ex) {
                log.warn("exception thrown from event handler after response is complete", (Throwable)ex);
            }
            catch (NotAuthorizedException ex) {
                log.warn("exception thrown from event handler after response is complete", (Throwable)ex);
            }
        }
        finally {
            this.clearThreadAffinity();
        }
    }

    private void clearThreadAffinity() {
        tlRequest.remove();
        tlResponse.remove();
        try {
            mapOfRequestsByThread.remove(Thread.currentThread());
        }
        catch (Throwable e) {
            log.info("Couldnt clear thread affinity request data");
        }
    }

    private void setThreadAffinityData(Request request, Response response) {
        tlRequest.set(request);
        tlResponse.set(response);
        try {
            RequestInfo info = new RequestInfo(request.getMethod(), request.getAbsoluteUrl(), new Date());
            mapOfRequestsByThread.put(Thread.currentThread(), info);
        }
        catch (Throwable e) {
            log.info("Couldnt set thread affinity request data");
        }
    }

    public void addEventListener(EventListener l) {
        this.eventListeners.add(l);
    }

    public void removeEventListener(EventListener l) {
        this.eventListeners.remove(l);
    }

    public void onProcessResourceFinish(Request request, Response response, Resource resource, long duration) {
        for (EventListener l : this.eventListeners) {
            l.onProcessResourceFinish(request, response, resource, duration);
        }
    }

    public void onProcessResourceStart(Request request, Response response, Resource resource) {
        for (EventListener l : this.eventListeners) {
            l.onProcessResourceStart(request, response, resource);
        }
    }

    public void onPost(Request request, Response response, Resource resource, Map<String, String> params, Map<String, FileItem> files) {
        for (EventListener l : this.eventListeners) {
            l.onPost(request, response, resource, params, files);
        }
    }

    public void onGet(Request request, Response response, Resource resource, Map<String, String> params) {
        for (EventListener l : this.eventListeners) {
            l.onGet(request, response, resource, params);
        }
    }

    public List<Filter> getFilters() {
        ArrayList<Filter> col = new ArrayList<Filter>(this.filters);
        return col;
    }

    public Collection<Handler> getAllHandlers() {
        return this.methodHandlers.values();
    }

    public Http11ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public ProtocolHandlers getHandlers() {
        return this.handlers;
    }

    public boolean isEnableExpectContinue() {
        return this.handlers.isEnableExpectContinue();
    }

    public void setEnableExpectContinue(boolean enableExpectContinue) {
        this.handlers.setEnableExpectContinue(enableExpectContinue);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    private void fireRequestEvent(Request request) throws ConflictException, BadRequestException, NotAuthorizedException {
        if (this.eventManager == null) {
            return;
        }
        this.eventManager.fireEvent((Event)new RequestEvent(request));
    }

    private void fireResponseEvent(Request request, Response response, long duration) throws ConflictException, BadRequestException, NotAuthorizedException {
        if (this.eventManager == null) {
            return;
        }
        this.eventManager.fireEvent((Event)new ResponseEvent(request, response, duration));
    }

    public List<CustomPostHandler> getCustomPostHandlers() {
        ArrayList<CustomPostHandler> list = new ArrayList<CustomPostHandler>();
        for (HttpExtension p : this.handlers) {
            if (p.getCustomPostHandlers() == null) continue;
            for (CustomPostHandler h : p.getCustomPostHandlers()) {
                list.add(h);
            }
        }
        return list;
    }

    public final void shutdown() {
        for (Stoppable stoppable : this.shutdownHandlers) {
            try {
                stoppable.stop();
            }
            catch (Throwable e) {
                log.warn("Exception stopping: " + stoppable.getClass(), e);
            }
        }
    }

    public EntityTransport getEntityTransport() {
        return this.entityTransport;
    }

    public class RequestInfo {
        private final Request.Method method;
        private final String url;
        private final Date started;

        public RequestInfo(Request.Method method, String url, Date started) {
            this.method = method;
            this.url = url;
            this.started = started;
        }

        public Request.Method getMethod() {
            return this.method;
        }

        public Date getStarted() {
            return this.started;
        }

        public String getUrl() {
            return this.url;
        }

        public long getDurationMillis() {
            return System.currentTimeMillis() - this.started.getTime();
        }
    }
}

