/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.common.Path;
import io.milton.event.AccessedEvent;
import io.milton.event.Event;
import io.milton.http.AuthenticationService;
import io.milton.http.ExistingEntityHandler;
import io.milton.http.FileItem;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.RequestParseException;
import io.milton.http.ResourceHandler;
import io.milton.http.Response;
import io.milton.http.UrlAdapter;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.resource.Resource;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHandlerHelper {
    private static final Logger log = LoggerFactory.getLogger(ResourceHandlerHelper.class);
    public static final String ATT_NAME_PARAMS = "_params";
    public static final String ATT_NAME_FILES = "_files";
    private final HandlerHelper handlerHelper;
    private final Http11ResponseHandler responseHandler;
    private final UrlAdapter urlAdapter;
    private final AuthenticationService authenticationService;

    public ResourceHandlerHelper(HandlerHelper handlerHelper, UrlAdapter urlAdapter, Http11ResponseHandler responseHandler, AuthenticationService authenticationService) {
        if (handlerHelper == null) {
            throw new IllegalArgumentException("handlerHelper may not be null");
        }
        this.responseHandler = responseHandler;
        this.urlAdapter = urlAdapter;
        this.handlerHelper = handlerHelper;
        this.authenticationService = authenticationService;
    }

    public void process(HttpManager manager, Request request, Response response, ResourceHandler handler) throws NotAuthorizedException, ConflictException, BadRequestException {
        LinkedHashMap params = new LinkedHashMap();
        HashMap files = new HashMap();
        try {
            request.parseRequestParameters(params, files);
        }
        catch (RequestParseException ex) {
            if (log.isTraceEnabled()) {
                log.warn("failed to parse request parameters: {}", (Object)ex.getMessage(), (Object)ex);
            } else {
                log.warn("failed to parse request parameters: {}", (Object)ex.getMessage());
            }
            return;
        }
        request.getAttributes().put(ATT_NAME_PARAMS, params);
        request.getAttributes().put(ATT_NAME_FILES, files);
        if (!this.handlerHelper.checkExpects(this.responseHandler, request, response)) {
            return;
        }
        String host = request.getHostHeader();
        String url = this.urlAdapter.getUrl(request);
        long tm = System.currentTimeMillis();
        Resource r = manager.getResourceFactory().getResource(host, url);
        tm = System.currentTimeMillis() - tm;
        if (tm > 100L) {
            log.debug("process: found resource={} in {}ms", (Object)r, (Object)tm);
        }
        if (r == null) {
            Resource parent;
            if (!request.getMethod().equals((Object)Request.Method.OPTIONS) && !this.authenticationService.authenticateDetailsPresent(request) && (parent = this.findClosestParent(manager, host, url)) != null) {
                if (request.getMethod().isWrite) {
                    throw new NotAuthorizedException("Authentication is required for write access", parent);
                }
                boolean allowsHead = parent.authorise(request, Request.Method.HEAD, null);
                if (!allowsHead) {
                    throw new NotAuthorizedException("Authentication is required for read access", parent);
                }
            }
            this.responseHandler.respondNotFound(response, request);
            return;
        }
        handler.processResource(manager, request, response, r);
    }

    public void processResource(HttpManager manager, Request request, Response response, Resource resource, ExistingEntityHandler handler) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.processResource(manager, request, response, resource, handler, false, null, null);
    }

    public void processResource(HttpManager manager, Request request, Response response, Resource resource, ExistingEntityHandler handler, Map<String, String> params, Map<String, FileItem> files) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.processResource(manager, request, response, resource, handler, false, params, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResource(HttpManager manager, Request request, Response response, Resource resource, ExistingEntityHandler handler, boolean allowRedirect, Map<String, String> params, Map<String, FileItem> files) throws NotAuthorizedException, ConflictException, BadRequestException {
        log.trace("processResource");
        long t = System.currentTimeMillis();
        try {
            manager.onProcessResourceStart(request, response, resource);
            boolean authorised = this.handlerHelper.checkAuthorisation(manager, resource, request);
            if (this.handlerHelper.isNotCompatible(resource, request.getMethod()) || !handler.isCompatible(resource)) {
                if (log.isInfoEnabled()) {
                    log.info("resource not compatible. Resource class: " + resource.getClass() + " handler: " + handler.getClass());
                }
                this.responseHandler.respondMethodNotImplemented(resource, response, request);
                return;
            }
            if (allowRedirect) {
                log.trace("check redirect");
                if (this.handlerHelper.doCheckRedirect(this.responseHandler, request, response, resource)) {
                    return;
                }
            }
            if (!authorised) {
                if (log.isInfoEnabled()) {
                    log.info("authorisation failed. respond with: " + this.responseHandler.getClass().getCanonicalName() + " resource: " + resource.getClass().getCanonicalName());
                }
                this.responseHandler.respondUnauthorised(resource, response, request);
                return;
            }
            AccessedEvent e = new AccessedEvent(resource);
            manager.getEventManager().fireEvent((Event)e);
            String redirectUrl = e.getReturnRedirectUrl();
            if (redirectUrl != null) {
                if (allowRedirect) {
                    log.debug("event handler returned redirect");
                    this.responseHandler.respondRedirect(response, request, redirectUrl);
                    return;
                }
                log.warn("Would have done redirect from event handler, but redirect is disabled for this request");
            }
            if (request.getMethod().isWrite && request.getMethod() != Request.Method.POST && this.handlerHelper.isLockedOut(request, resource)) {
                response.setStatus(Response.Status.SC_LOCKED);
                return;
            }
            try {
                handler.processExistingResource(manager, request, response, resource);
            }
            catch (NotFoundException ex) {
                log.warn("Not found exception thrown from handler: " + handler.getClass(), (Throwable)ex);
                this.responseHandler.respondNotFound(response, request);
            }
        }
        finally {
            t = System.currentTimeMillis() - t;
            manager.onProcessResourceFinish(request, response, resource, t);
        }
    }

    public boolean isNotCompatible(Resource r, Request.Method m) {
        return this.handlerHelper.isNotCompatible(r, m);
    }

    public boolean isLockedOut(Request inRequest, Resource inResource) {
        return this.handlerHelper.isLockedOut(inRequest, inResource);
    }

    public AuthenticationService.AuthStatus checkAuthentication(HttpManager manager, Resource resource, Request request) {
        return this.handlerHelper.checkAuthentication(manager, resource, request);
    }

    public UrlAdapter getUrlAdapter() {
        return this.urlAdapter;
    }

    public Http11ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    private Resource findClosestParent(HttpManager manager, String host, String url) throws NotAuthorizedException, BadRequestException {
        Path p = Path.path((String)url);
        return this.findClosestParent(manager, host, p);
    }

    private Resource findClosestParent(HttpManager manager, String host, Path p) throws NotAuthorizedException, BadRequestException {
        if ((p = p.getParent()) == null) {
            return null;
        }
        Resource parent = manager.getResourceFactory().getResource(host, p.toString());
        if (parent != null) {
            return parent;
        }
        return this.findClosestParent(manager, host, p);
    }
}

