/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.Get;
import io.milton.annotations.Post;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationHandler;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.annotated.SpecificityUtils;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.resource.Resource;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnnotationHandler
implements AnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractAnnotationHandler.class);
    protected final AnnotationResourceFactory annoResourceFactory;
    protected final Class annoClass;
    protected final Request.Method[] methods;
    List<ControllerMethod> controllerMethods = new ArrayList<ControllerMethod>();

    public AbstractAnnotationHandler(AnnotationResourceFactory outer, Class annoClass, Request.Method ... methods) {
        this.annoResourceFactory = outer;
        this.annoClass = annoClass;
        this.methods = methods;
    }

    @Override
    public Class getAnnoClass() {
        return this.annoClass;
    }

    @Override
    public void parseController(Object controller) {
        for (Method m : controller.getClass().getMethods()) {
            Object a = m.getAnnotation(this.annoClass);
            if (a == null) continue;
            Class<?>[] params = m.getParameterTypes();
            if (params == null || params.length == 0) {
                throw new RuntimeException("Invalid controller method: " + m.getName() + " does not have a source argument");
            }
            Class<?> sourceType = params[0];
            ControllerMethod cm = new ControllerMethod(controller, m, sourceType, (Annotation)a);
            this.controllerMethods.add(cm);
        }
    }

    ControllerMethod getBestMethod(Class sourceClass) {
        return this.getBestMethod(sourceClass, null);
    }

    ControllerMethod getBestMethod(Class sourceClass, String contentType) {
        return this.getBestMethod(sourceClass, contentType, null, null);
    }

    ControllerMethod getBestMethod(Class sourceClass, String contentType, Map<String, String> params, Class returnType) {
        ControllerMethod foundMethod = null;
        int foundMethodScore = -1;
        for (ControllerMethod cm : this.controllerMethods) {
            if (!cm.sourceType.isAssignableFrom(sourceClass) || !this.isReturnTypeMatch(cm.method, returnType)) continue;
            int score = 0;
            int i = this.contentTypeMatch(contentType, cm.anno);
            if (i < 0) continue;
            score += i;
            i = this.isParamMatch(params, cm.anno);
            if (i < 0) continue;
            score += i;
            if ((score += SpecificityUtils.sourceSpecifityIndex(cm.sourceType, sourceClass)) > foundMethodScore) {
                foundMethod = cm;
                foundMethodScore = score;
                if (!log.isTraceEnabled()) continue;
                log.trace("Found high score method: " + cm + " with score: " + foundMethod);
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("Not using method: " + cm + " because score:" + score + " is lower then best: " + foundMethodScore);
        }
        return foundMethod;
    }

    public ControllerMethod getMethodForType(AnnoCollectionResource parent, String type) {
        List<ControllerMethod> foundMethods = this.getMethods(parent.getSource().getClass(), type);
        if (foundMethods.isEmpty()) {
            return null;
        }
        return foundMethods.get(0);
    }

    List<ControllerMethod> getMethods(Class sourceClass) {
        ArrayList<ControllerMethod> foundMethods = new ArrayList<ControllerMethod>();
        for (ControllerMethod cm : this.controllerMethods) {
            Class key = cm.sourceType;
            if (!key.isAssignableFrom(sourceClass)) continue;
            foundMethods.add(cm);
        }
        return foundMethods;
    }

    List<ControllerMethod> getMethods(Class sourceClass, String sourceClassName) {
        ArrayList<ControllerMethod> foundMethods = new ArrayList<ControllerMethod>();
        for (ControllerMethod cm : this.controllerMethods) {
            Class key = cm.sourceType;
            if (!key.isAssignableFrom(sourceClass) || sourceClassName != null && !cm.method.getReturnType().getCanonicalName().endsWith(sourceClassName)) continue;
            foundMethods.add(cm);
        }
        return foundMethods;
    }

    @Override
    public Request.Method[] getSupportedMethods() {
        return this.methods;
    }

    @Override
    public boolean isCompatible(Object source) {
        ControllerMethod m;
        String contentType = null;
        Map params = null;
        Request req = HttpManager.request();
        if (req != null) {
            contentType = req.getContentTypeHeader();
            params = req.getParams();
        }
        return (m = this.getBestMethod(source.getClass(), contentType, params, null)) != null;
    }

    protected Object attemptToReadProperty(Object source, String ... propNames) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (String propName : propNames) {
            if (!PropertyUtils.isReadable((Object)source, (String)propName)) continue;
            Object oName = PropertyUtils.getProperty((Object)source, (String)propName);
            return oName;
        }
        return null;
    }

    protected boolean attemptToSetProperty(Object source, Object value, String ... propNames) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (String propName : propNames) {
            if (!PropertyUtils.isWriteable((Object)source, (String)propName)) continue;
            PropertyUtils.setProperty((Object)source, (String)propName, (Object)value);
            return true;
        }
        return false;
    }

    private int contentTypeMatch(String reqContentType, Annotation anno) {
        Get g;
        if (anno instanceof Get && (g = (Get)anno).contentType() != null && g.contentType().length() > 0) {
            if (g.contentType().equals(reqContentType)) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    private int isParamMatch(Map<String, String> params, Annotation anno) {
        String[] matchParams;
        if (anno instanceof Get) {
            Get g = (Get)anno;
            matchParams = g.params();
        } else if (anno instanceof Post) {
            Post p = (Post)anno;
            matchParams = p.params();
        } else {
            matchParams = null;
        }
        if (matchParams != null && matchParams.length > 0) {
            for (String paramName : matchParams) {
                if (params != null && params.containsKey(paramName)) continue;
                return -1;
            }
            return matchParams.length;
        }
        return 0;
    }

    protected Object invoke(ControllerMethod cm, AnnoResource sourceRes, Object ... values) throws NotAuthorizedException, BadRequestException, NotFoundException, Exception {
        try {
            Object[] args = values == null || values.length == 0 ? this.annoResourceFactory.buildInvokeArgs(sourceRes, cm.method, new Object[0]) : this.annoResourceFactory.buildInvokeArgs(sourceRes, cm.method, values);
            return cm.method.invoke(cm.controller, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NotAuthorizedException) {
                NotAuthorizedException nae = (NotAuthorizedException)cause;
                if (nae.getResource() == null) {
                    throw new NotAuthorizedException((Resource)sourceRes, (Throwable)nae);
                }
                throw nae;
            }
            if (cause instanceof BadRequestException) {
                throw (BadRequestException)cause;
            }
            if (cause instanceof NotFoundException) {
                throw (NotFoundException)cause;
            }
            if (cause instanceof ConflictException) {
                throw (ConflictException)cause;
            }
            throw e;
        }
        catch (NotAuthorizedException e) {
            throw e;
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception("Method: " + cm, e);
        }
    }

    private boolean isReturnTypeMatch(Method method, Class returnType) {
        if (returnType == null) {
            return true;
        }
        return returnType.isAssignableFrom(method.getReturnType());
    }

    @Override
    public List<ControllerMethod> getControllerMethods() {
        return this.controllerMethods;
    }
}

