/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.Get;
import io.milton.common.JsonResult;
import io.milton.common.ModelAndView;
import io.milton.http.AclUtils;
import io.milton.http.Auth;
import io.milton.http.ConditionalCompatibleResource;
import io.milton.http.FileItem;
import io.milton.http.HttpManager;
import io.milton.http.LockInfo;
import io.milton.http.LockResult;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnoPrincipalResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.CommonResource;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.annotated.JsonWriter;
import io.milton.http.annotated.ResourceList;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.LockedException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.exceptions.PreConditionFailedException;
import io.milton.http.http11.auth.DigestResponse;
import io.milton.http.values.HrefList;
import io.milton.principal.DiscretePrincipal;
import io.milton.principal.Principal;
import io.milton.resource.AccessControlledResource;
import io.milton.resource.CollectionResource;
import io.milton.resource.CopyableResource;
import io.milton.resource.DeletableResource;
import io.milton.resource.DigestResource;
import io.milton.resource.DisplayNameResource;
import io.milton.resource.GetableResource;
import io.milton.resource.LockableResource;
import io.milton.resource.MoveableResource;
import io.milton.resource.PostableResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.ReportableResource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnoResource
implements GetableResource,
PropFindableResource,
DeletableResource,
CopyableResource,
MoveableResource,
LockableResource,
ConditionalCompatibleResource,
CommonResource,
DigestResource,
PostableResource,
ReportableResource,
AccessControlledResource,
DisplayNameResource {
    private static final Logger log = LoggerFactory.getLogger(AnnoResource.class);
    protected Object source;
    protected final AnnotationResourceFactory annoFactory;
    protected AnnoCollectionResource parent;
    protected JsonResult jsonResult;
    protected String nameOverride;
    protected Set<AccessControlledResource.Priviledge> acl;
    protected String realm;

    public AnnoResource(AnnotationResourceFactory outer, Object source, AnnoCollectionResource parent) {
        if (source == null) {
            throw new RuntimeException("Source object is required");
        }
        this.annoFactory = outer;
        this.source = source;
        this.parent = parent;
    }

    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException, ConflictException {
        Request request = HttpManager.request();
        Object result = this.annoFactory.postAnnotationHandler.execute(this, request, parameters);
        if (result instanceof String) {
            String redirect = (String)result;
            return redirect;
        }
        this.jsonResult = result instanceof JsonResult ? (JsonResult)result : JsonResult.returnData((String)this.getHref(), (Object)result);
        return null;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException, NotFoundException {
        if (this.jsonResult == null) {
            this.annoFactory.getAnnotationHandler.execute(this, out, range, params, contentType);
        } else {
            JsonWriter jsonWriter = new JsonWriter();
            jsonWriter.write(this.jsonResult, out);
        }
    }

    public String getUniqueId() {
        String o = this.annoFactory.uniqueIdAnnotationHandler.get(this);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public String getName() {
        if (this.nameOverride != null) {
            return this.nameOverride;
        }
        String name = this.annoFactory.nameAnnotationHandler.get(this);
        if (name == null) {
            log.warn("No @Name for source class: " + this.source.getClass() + " Please implement a @Name method to identify the name of this type");
            name = this.source.toString();
        }
        return name;
    }

    public Object authenticate(String user, String password) {
        AnnoPrincipalResource userRes;
        try {
            userRes = this.annoFactory.usersAnnotationHandler.findUser(this.getRoot(), user);
        }
        catch (NotAuthorizedException ex) {
            log.warn("authenticate: Failed to locate a user", (Throwable)ex);
            return null;
        }
        catch (BadRequestException ex) {
            log.warn("authenticate: Failed to locate a user", (Throwable)ex);
            return null;
        }
        if (userRes != null) {
            Boolean b;
            if (log.isTraceEnabled()) {
                log.trace("authenticate(Basic): user=" + user + " found object: " + userRes.getSource());
            }
            if ((b = this.annoFactory.authenticateAnnotationHandler.authenticate(userRes, password)) != null && b.booleanValue()) {
                if (log.isTraceEnabled()) {
                    log.trace("annotated authenticate method verified credentials");
                }
                return userRes;
            }
            if (log.isTraceEnabled()) {
                log.trace("annotated authenticate method rejected credentials");
            }
        } else if (log.isInfoEnabled()) {
            log.info("user " + user + " was not found from annotated methods");
        }
        Object oUser = this.annoFactory.getSecurityManager().authenticate(user, password);
        if (log.isDebugEnabled()) {
            if (oUser == null) {
                log.debug("authenticate(Basic): did not find a user from: " + this.annoFactory.getSecurityManager());
            } else {
                log.debug("authenticate(Basic): found a valid user from: " + this.annoFactory.getSecurityManager());
            }
        }
        return oUser;
    }

    public Object authenticate(DigestResponse digestRequest) {
        AnnoPrincipalResource userRes;
        try {
            userRes = this.annoFactory.usersAnnotationHandler.findUser(this.getRoot(), digestRequest.getUser());
        }
        catch (NotAuthorizedException ex) {
            log.warn("authenticate: Failed to locate a user", (Throwable)ex);
            return null;
        }
        catch (BadRequestException ex) {
            log.warn("authenticate: Failed to locate a user", (Throwable)ex);
            return null;
        }
        if (userRes != null) {
            Boolean b = this.annoFactory.authenticateAnnotationHandler.authenticate(userRes, digestRequest);
            if (b != null && b.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("authenticate(Digest): user=" + digestRequest.getUser() + " found valid user: " + userRes.getSource());
                }
                return userRes;
            }
            if (log.isDebugEnabled()) {
                log.debug("authenticate(Digest): user=" + digestRequest.getUser() + " found user: " + userRes.getSource() + " but authentication failed");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("authenticate(Digest): user=" + digestRequest.getUser() + " was not found from annotated methods.");
        }
        Object oUser = this.annoFactory.getSecurityManager().authenticate(digestRequest);
        if (log.isDebugEnabled()) {
            if (oUser == null) {
                log.debug("authenticate(Digest): did not find a user from: " + this.annoFactory.getSecurityManager());
            } else {
                log.debug("authenticate(Digest): found a valid user from: " + this.annoFactory.getSecurityManager());
            }
        }
        return oUser;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        Object oUser = null;
        if (auth != null) {
            oUser = auth.getTag();
        }
        if (!this.annoFactory.accessControlListAnnotationHandler.getControllerMethods().isEmpty()) {
            boolean allows;
            AccessControlledResource.Priviledge requiredPriv;
            if (this.acl == null) {
                if (log.isDebugEnabled()) {
                    if (oUser != null) {
                        log.debug("authorise: find ACL for principle={}", oUser);
                    } else if (oUser == null) {
                        log.debug("authorise: no logged in user, get ACL for anonymous access");
                    }
                }
                this.acl = this.annoFactory.accessControlListAnnotationHandler.availablePrivs(oUser, this, auth);
                if (this.acl == null) {
                    log.info("authorise: got a null access control list");
                }
            }
            if ((requiredPriv = this.annoFactory.accessControlListAnnotationHandler.requiredPriv(this, method, request)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug("authorise: request permitted because required priviledge is null");
                }
                allows = true;
            } else {
                allows = AclUtils.containsPriviledge((AccessControlledResource.Priviledge)requiredPriv, this.acl);
                if (!allows) {
                    if (oUser != null) {
                        log.info("Authorisation declined for user: {}", oUser);
                    } else {
                        log.info("Authorisation declined for anonymous access");
                    }
                    if (this.acl != null) {
                        log.info("Required priviledge: " + requiredPriv + " was not found in assigned priviledge list of size: " + this.acl.size());
                    } else {
                        log.info("Null ACL list");
                    }
                }
            }
            return allows;
        }
        if (log.isDebugEnabled()) {
            log.debug("authorise: ACL cannot be calculated so use security manager: " + this.annoFactory.getSecurityManager());
        }
        return this.annoFactory.getSecurityManager().authorise(request, method, auth, this);
    }

    public String getRealm() {
        if (this.realm == null) {
            this.realm = this.annoFactory.realmAnnotationHandler.get(this);
            if (this.realm == null) {
                this.realm = this.parent != null ? this.parent.getRealm() : this.annoFactory.getSecurityManager().getRealm(HttpManager.request().getHostHeader());
            }
        }
        return this.realm;
    }

    public Date getModifiedDate() {
        Date o = this.annoFactory.modifiedDateAnnotationHandler.get(this);
        if (o instanceof Date) {
            return o;
        }
        if (o == null) {
            return null;
        }
        log.warn("Got an incompatible value for ModifiedDate for source object: " + this.source.getClass() + " Is a: " + o.getClass() + " should be: " + Date.class);
        log.warn(" ModifiedDate=" + o);
        return null;
    }

    public String checkRedirect(Request request) throws NotAuthorizedException, BadRequestException {
        return null;
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        this.annoFactory.deleteAnnotationHandler.execute(this);
    }

    @Override
    public boolean isCompatible(Request.Method m) {
        if (Request.Method.PROPFIND.equals((Object)m)) {
            return true;
        }
        return this.annoFactory.isCompatible(this.source, m);
    }

    @Override
    public boolean is(String type) {
        if (this.matchesType(this.source.getClass(), type)) {
            return true;
        }
        for (Class<?> c : this.source.getClass().getClasses()) {
            if (!this.matchesType(c, type)) continue;
            return true;
        }
        return false;
    }

    public Date getCreateDate() {
        return this.annoFactory.createdDateAnnotationHandler.get(this);
    }

    public void moveTo(CollectionResource rDest, String name) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.nameOverride = null;
        this.annoFactory.moveAnnotationHandler.execute(this, rDest, name);
    }

    public Object getSource() {
        return this.source;
    }

    public AnnotationResourceFactory getAnnoFactory() {
        return this.annoFactory;
    }

    @Override
    public AnnoCollectionResource getParent() {
        return this.parent;
    }

    public void copyTo(CollectionResource toCollection, String name) throws NotAuthorizedException, BadRequestException, ConflictException {
        this.annoFactory.copyAnnotationHandler.execute(this, toCollection, name);
    }

    public Long getMaxAgeSeconds(Auth auth) {
        ControllerMethod cm = this.annoFactory.getAnnotationHandler.getBestMethod(this.source.getClass());
        if (cm != null) {
            Get g = (Get)cm.anno;
            long l = g.maxAgeSecs();
            if (l == 0L) {
                return null;
            }
            if (l > 0L) {
                return l;
            }
            if (ModelAndView.class.isAssignableFrom(cm.method.getReturnType())) {
                return null;
            }
        }
        Long l = this.annoFactory.maxAgeAnnotationHandler.get(this);
        return l;
    }

    public String getContentType(String accepts) {
        if (accepts != null && accepts.contains("application/json")) {
            return "application/json";
        }
        return this.annoFactory.contentTypeAnnotationHandler.get(accepts, this);
    }

    public String getContentType() {
        return this.annoFactory.contentTypeAnnotationHandler.get(null, this);
    }

    public Long getContentLength() {
        return this.annoFactory.contentLengthAnnotationHandler.get(this);
    }

    public boolean isDigestAllowed() {
        boolean b = this.annoFactory.getSecurityManager().isDigestAllowed();
        if (!b) {
            log.trace("Diget auth is not supported by security manager");
        }
        return b;
    }

    public ResourceList getAsList() {
        ResourceList l = new ResourceList();
        l.add(this);
        return l;
    }

    private boolean matchesType(Class c, String type) {
        String name = c.getCanonicalName();
        int pos = name.lastIndexOf(".");
        return (name = name.substring(pos + 1)).equalsIgnoreCase(type);
    }

    public String getHref() {
        if (this.parent == null) {
            return this.annoFactory.getValidContextPath();
        }
        String s = this.parent.getHref() + this.getName();
        if (this instanceof CollectionResource) {
            s = s + "/";
        }
        return s;
    }

    public AnnoCollectionResource getRoot() {
        return this.parent.getRoot();
    }

    public String getLink() {
        return "<a href=\"" + this.getHref() + "\">" + this.getName() + "</a>";
    }

    public String getDisplayName() {
        return this.annoFactory.displayNameAnnotationHandler.executeRead(this);
    }

    public void setDisplayName(String s) {
        this.annoFactory.displayNameSetterAnnotationHandler.executeWrite(this, s);
    }

    public LockResult lock(LockTimeout timeout, LockInfo lockInfo) throws NotAuthorizedException, PreConditionFailedException, LockedException {
        return this.annoFactory.getLockManager().lock(timeout, lockInfo, (LockableResource)this);
    }

    public LockResult refreshLock(String token) throws NotAuthorizedException, PreConditionFailedException {
        return this.annoFactory.getLockManager().refresh(token, (LockableResource)this);
    }

    public void unlock(String tokenId) throws NotAuthorizedException, PreConditionFailedException {
        this.annoFactory.getLockManager().unlock(tokenId, (LockableResource)this);
    }

    public LockToken getCurrentLock() {
        if (this.annoFactory.getLockManager() != null) {
            return this.annoFactory.getLockManager().getCurrentToken((LockableResource)this);
        }
        return null;
    }

    public String getNameOverride() {
        return this.nameOverride;
    }

    public void setNameOverride(String nameOverride) {
        this.nameOverride = nameOverride;
    }

    public HrefList getPrincipalCollectionHrefs() {
        List<AnnoCollectionResource> list = this.annoFactory.usersAnnotationHandler.findUsersCollections(this.getRoot());
        HrefList l = new HrefList();
        for (AnnoCollectionResource col : list) {
            l.add((Object)col.getHref());
        }
        return l;
    }

    public List<AccessControlledResource.Priviledge> getPriviledges(Auth auth) {
        Set<AccessControlledResource.Priviledge> set;
        AnnoPrincipalResource curUser = null;
        if (auth != null && auth.getTag() instanceof AnnoPrincipalResource) {
            curUser = (AnnoPrincipalResource)auth.getTag();
        }
        if ((set = this.annoFactory.accessControlListAnnotationHandler.availablePrivs(curUser, this, auth)) != null && !set.isEmpty()) {
            return new ArrayList<AccessControlledResource.Priviledge>(set);
        }
        log.warn("Empty privs for: " + curUser);
        return Collections.EMPTY_LIST;
    }

    public void setAccessControlList(Map<Principal, List<AccessControlledResource.Priviledge>> privs) {
    }

    public Map<Principal, List<AccessControlledResource.Priviledge>> getAccessControlList() {
        log.warn("getAccessControlList - not implemented");
        return null;
    }

    public String getPrincipalURL() {
        for (AnnoCollectionResource p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof DiscretePrincipal)) continue;
            return p.getHref();
        }
        return null;
    }
}

