/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.ChildOf;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildOfAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(ChildOfAnnotationHandler.class);
    public static final String NOT_ATTEMPTED = "NotAttempted";

    public ChildOfAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, ChildOf.class, new Request.Method[0]);
    }

    public Object execute(AnnoCollectionResource parent, String childName) throws NotAuthorizedException, BadRequestException, NotFoundException {
        Object source = parent.getSource();
        try {
            List<ControllerMethod> availMethods = this.getMethods(source.getClass());
            if (availMethods.isEmpty()) {
                return NOT_ATTEMPTED;
            }
            for (ControllerMethod cm : availMethods) {
                Object childObject;
                if (!this.matchesSuffix(cm, childName) || (childObject = this.invoke(cm, parent, childName)) == null) continue;
                AnnoResource r = this.annoResourceFactory.instantiate(childObject, parent, cm.method);
                r.setNameOverride(childName);
                return r;
            }
        }
        catch (NotAuthorizedException e) {
            throw e;
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private boolean matchesSuffix(ControllerMethod cm, String childName) {
        ChildOf a = (ChildOf)cm.anno;
        if (!a.pathSuffix().isEmpty()) {
            return childName.endsWith(a.pathSuffix());
        }
        return true;
    }
}

