/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.ContentType;
import io.milton.common.ContentTypeUtils;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import java.lang.reflect.Method;

public class ContentTypeAnnotationHandler
extends AbstractAnnotationHandler {
    protected final String[] propertyNames;

    public ContentTypeAnnotationHandler(AnnotationResourceFactory outer, String ... propNames) {
        super(outer, ContentType.class, new Request.Method[0]);
        this.propertyNames = propNames;
    }

    public String get(String accepts, AnnoResource res) {
        Object source = res.getSource();
        try {
            ControllerMethod cm = this.getBestMethod(source.getClass(), null, null, Object.class);
            if (cm != null) {
                String val = (String)this.invoke(cm, res, accepts);
                return val;
            }
            Method m = this.annoResourceFactory.findMethodForAnno(source.getClass(), this.annoClass);
            if (m != null) {
                String val = (String)m.invoke(source, accepts);
                return val;
            }
            for (String propName : this.propertyNames) {
                Object s = this.attemptToReadProperty(source, propName);
                if (s == null) continue;
                return (String)s;
            }
            return ContentTypeUtils.findAcceptableContentTypeForName((String)res.getName(), (String)accepts);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception executing " + this.annoClass + " - " + source.getClass(), e);
        }
    }
}

