/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.CommonResource;
import io.milton.http.annotated.LockHolder;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.DeletableResource;
import io.milton.resource.ReplaceableResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class LockNullResource
implements CommonResource,
DeletableResource,
ReplaceableResource {
    private final AnnotationResourceFactory annoFactory;
    private final AnnoCollectionResource parent;
    private final LockHolder lockHolder;

    public LockNullResource(AnnotationResourceFactory annoFactory, AnnoCollectionResource parent, LockHolder lockHolder) {
        this.annoFactory = annoFactory;
        this.parent = parent;
        this.lockHolder = lockHolder;
    }

    @Override
    public boolean is(String type) {
        return false;
    }

    @Override
    public CommonResource getParent() {
        return this.parent;
    }

    public String getUniqueId() {
        return this.lockHolder.getId().toString();
    }

    public String getName() {
        return this.lockHolder.getName();
    }

    public Object authenticate(String user, String password) {
        return this.parent.authenticate(user, password);
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return this.parent.authorise(request, method, auth);
    }

    public String getRealm() {
        return this.parent.getRealm();
    }

    public Date getModifiedDate() {
        return this.lockHolder.getCreatedDate();
    }

    public String checkRedirect(Request request) throws NotAuthorizedException, BadRequestException {
        return null;
    }

    public void delete() {
        this.annoFactory.removeLockHolder(this.parent, this.lockHolder.getName());
    }

    public void replaceContent(InputStream in, Long length) throws BadRequestException, ConflictException, NotAuthorizedException {
        this.delete();
        try {
            this.parent.createNew(this.lockHolder.getName(), in, length, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

