/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.Post;
import io.milton.common.JsonResult;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.annotated.DataBinder;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(PostAnnotationHandler.class);

    public PostAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, Post.class, Request.Method.POST);
    }

    public Object execute(AnnoResource resource, Request request, Map<String, String> params) throws BadRequestException, NotAuthorizedException, ConflictException {
        Object source = resource.getSource();
        ControllerMethod cm = this.getBestMethod(source.getClass(), null, params, null);
        if (cm == null) {
            throw new RuntimeException("Method not found: " + this.getClass() + " - " + source.getClass());
        }
        log.trace("execute POST method: " + cm.method.getName());
        Post a = cm.method.getAnnotation(Post.class);
        try {
            if (a.bindData()) {
                String sTimezone;
                TimeZone tz = null;
                if (a.timeZoneParam().length() > 0 && (sTimezone = DataBinder.getRawParam(params, a.timeZoneParam())) != null) {
                    tz = TimeZone.getTimeZone(sTimezone);
                }
                DataBinder dataBinder = new DataBinder();
                dataBinder.populate(source, params, tz);
                resource.setNameOverride(null);
            }
        }
        catch (IllegalAccessException e) {
            log.warn("Exception running DataBinder:", (Throwable)e);
            return JsonResult.error((String)e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.warn("Exception running DataBinder:", (Throwable)e);
            return JsonResult.error((String)e.getMessage());
        }
        try {
            Object[] args = this.annoResourceFactory.buildInvokeArgs(resource, cm.method, params);
            Object result = cm.method.invoke(cm.controller, args);
            return result;
        }
        catch (NotAuthorizedException e) {
            throw e;
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (ConflictException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ControllerMethod getPostMethod(AnnoResource resource, Request request, Map<String, String> params) {
        Object source = resource.getSource();
        ControllerMethod cm = this.getBestMethod(source.getClass(), null, params, null);
        return cm;
    }
}

