/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.PutChild;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoFileResource;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutChildAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(PutChildAnnotationHandler.class);

    public PutChildAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, PutChild.class, Request.Method.PUT);
    }

    public Object execute(AnnoResource res, String newName, InputStream inputStream, Long length, String contentType) throws ConflictException, NotAuthorizedException, BadRequestException {
        log.trace("execute PUT method");
        Object source = res.getSource();
        ControllerMethod cm = this.getBestMethod(source.getClass());
        if (cm == null) {
            if (this.controllerMethods.isEmpty()) {
                log.info("Method not found for source: {}. No methods registered for {}", (Object)source.getClass().getSimpleName(), (Object)PutChild.class.getSimpleName());
            } else {
                log.info("Method not found for source {}. Listing methods registered for {}: {}", new Object[]{source.getClass().getSimpleName(), PutChild.class.getSimpleName(), StringUtils.join((Collection)this.controllerMethods, (String)",")});
            }
            throw new RuntimeException("Method not found: " + this.getClass() + " - " + source.getClass());
        }
        try {
            return this.invoke(cm, res, newName, inputStream, length, contentType);
        }
        catch (NotAuthorizedException e) {
            throw e;
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (ConflictException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void replace(AnnoFileResource fileRes, InputStream inputStream, Long length) throws ConflictException, NotAuthorizedException, BadRequestException {
        log.trace("execute PUT (replace) method");
        Object source = fileRes.getSource();
        ControllerMethod cm = this.getBestMethod(source.getClass());
        if (cm == null) {
            String name = fileRes.getName();
            this.annoResourceFactory.deleteAnnotationHandler.execute(fileRes);
            this.execute(fileRes.getParent(), name, inputStream, length, null);
        } else {
            try {
                this.invoke(cm, fileRes, inputStream, length, fileRes);
            }
            catch (NotAuthorizedException e) {
                throw e;
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (ConflictException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

