/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.ChildrenOfTypeMap;
import io.milton.http.annotated.CommonResource;
import io.milton.resource.CollectionResource;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class ResourceList
extends ArrayList<CommonResource> {
    private static final long serialVersionUID = 1L;
    private final Map<String, CommonResource> map = new HashMap<String, CommonResource>();

    public ResourceList() {
    }

    public ResourceList(AnnoResource[] array) {
        this.addAll(Arrays.asList(array));
    }

    public ResourceList(ResourceList copyFrom) {
        super(copyFrom);
    }

    public ResourceList getDirs() {
        ResourceList list = new ResourceList();
        for (CommonResource cr : this) {
            if (!(cr instanceof CollectionResource)) continue;
            list.add(cr);
        }
        return list;
    }

    public ResourceList getFiles() {
        ResourceList list = new ResourceList();
        for (CommonResource cr : this) {
            if (cr instanceof CollectionResource) continue;
            list.add(cr);
        }
        return list;
    }

    @Override
    public boolean add(CommonResource e) {
        if (e == null) {
            throw new NullPointerException("Attempt to add null node");
        }
        if (e.getName() == null) {
            throw new NullPointerException("Attempt to add resource with null name: " + e.getClass().getName());
        }
        this.map.put(e.getName(), e);
        boolean b = super.add(e);
        return b;
    }

    public ResourceList add(ResourceList otherList) {
        this.addAll(otherList);
        return this;
    }

    public CommonResource get(String name) {
        return this.map.get(name);
    }

    public Resource remove(String name) {
        CommonResource r = this.map.remove(name);
        if (r != null) {
            super.remove(r);
        }
        return r;
    }

    public boolean hasChild(String name) {
        return this.get(name) != null;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Resource) {
            Resource e = (Resource)o;
            this.map.remove(e.getName());
        }
        return super.remove(o);
    }

    @Override
    public Resource getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return (Resource)this.get(0);
    }

    @Override
    public Resource getLast() {
        if (this.size() > 0) {
            return (Resource)this.get(this.size() - 1);
        }
        return null;
    }

    public Resource getRandom() {
        int l = this.size();
        if (l == 0) {
            return null;
        }
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (Resource res : this) {
            list.add(res);
        }
        if (list.isEmpty()) {
            return null;
        }
        Random rnd = new Random();
        int pos = rnd.nextInt(list.size());
        return (Resource)list.get(pos);
    }

    public ResourceList getReverse() {
        ResourceList list = new ResourceList(this);
        Collections.reverse(list);
        return list;
    }

    public ResourceList getSortByModifiedDate() {
        ResourceList list = new ResourceList(this);
        Collections.sort(list, new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                Date dt1 = o1.getModifiedDate();
                Date dt2 = o2.getModifiedDate();
                if (dt1 == null) {
                    return -1;
                }
                return -1 * dt1.compareTo(dt2);
            }
        });
        return list;
    }

    public ResourceList getSortByName() {
        ResourceList list = new ResourceList(this);
        Collections.sort(list, new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        return list;
    }

    public ResourceList getRandomSort() {
        AnnoResource[] array = new AnnoResource[this.size()];
        this.toArray(array);
        Random rng = new Random();
        int n = array.length;
        while (n > 1) {
            int k = rng.nextInt(n);
            AnnoResource temp = array[--n];
            array[n] = array[k];
            array[k] = temp;
        }
        ResourceList newList = new ResourceList(array);
        return newList;
    }

    public ResourceList exclude(String s) {
        return this._exclude(s);
    }

    public ResourceList exclude(String s1, String s2) {
        return this._exclude(s1, s2);
    }

    public ResourceList exclude(String s1, String s2, String s3) {
        return this._exclude(s1, s2, s3);
    }

    public ResourceList exclude(String s1, String s2, String s3, String s4) {
        return this._exclude(s1, s2, s3, s4);
    }

    public ResourceList _exclude(String ... s) {
        ResourceList newList = new ResourceList(this);
        Iterator it = newList.iterator();
        while (it.hasNext()) {
            Resource ct = (Resource)it.next();
            if (!this.contains(s, ct.getName())) continue;
            it.remove();
        }
        return newList;
    }

    private boolean contains(String[] arr, String name) {
        for (String s : arr) {
            if (!name.equals(s)) continue;
            return true;
        }
        return false;
    }

    public ResourceList ofType(String s) {
        ResourceList newList = new ResourceList(this);
        Iterator it = newList.iterator();
        while (it.hasNext()) {
            CommonResource ct = (CommonResource)it.next();
            if (ct.is(s)) continue;
            it.remove();
        }
        return newList;
    }

    public ResourceList truncate(int maxSize) {
        ResourceList list = new ResourceList();
        for (int i = 0; i < maxSize && i < this.size(); ++i) {
            list.add((CommonResource)this.get(i));
        }
        return list;
    }

    public Map<String, ResourceList> getOfType() {
        return new ChildrenOfTypeMap(this);
    }

    public Resource next(Resource from) {
        if (from == null) {
            return this.getFirst();
        }
        boolean found = false;
        for (Resource r : this) {
            if (found) {
                return r;
            }
            if (r != from) continue;
            found = true;
        }
        return null;
    }

    public ResourceList closest(String type) {
        ResourceList l = new ResourceList();
        Iterator iterator = this.iterator();
        block0: while (iterator.hasNext()) {
            for (CommonResource r = (CommonResource)iterator.next(); r != null; r = r.getParent()) {
                if (!r.is(type)) continue;
                l.add(r);
                continue block0;
            }
        }
        return l;
    }

    public Map<String, CommonResource> getMap() {
        return this.map;
    }
}

