/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.Users;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnoPrincipalResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.List;

public class UsersAnnotationHandler
extends AbstractAnnotationHandler {
    public static final String NOT_ATTEMPTED = "NotAttempted";

    public UsersAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, Users.class, new Request.Method[0]);
    }

    public AnnoPrincipalResource findUser(AnnoCollectionResource root, String name) throws NotAuthorizedException, BadRequestException {
        for (AnnoCollectionResource userHome : this.findUsersCollections(root)) {
            Resource r;
            List<ControllerMethod> availMethods = this.getMethods(userHome.getSource().getClass());
            if (availMethods.isEmpty() || !((r = userHome.child(name)) instanceof AnnoPrincipalResource)) continue;
            AnnoPrincipalResource apr = (AnnoPrincipalResource)r;
            return apr;
        }
        return null;
    }

    public List<AnnoCollectionResource> findUsersCollections(AnnoCollectionResource root) {
        try {
            ArrayList<AnnoCollectionResource> list = new ArrayList<AnnoCollectionResource>();
            for (Resource resource : root.getChildren()) {
                AnnoCollectionResource acr;
                List<ControllerMethod> availMethods;
                if (!(resource instanceof AnnoCollectionResource) || (availMethods = this.getMethods((acr = (AnnoCollectionResource)resource).getSource().getClass())).isEmpty()) continue;
                list.add(acr);
            }
            return list;
        }
        catch (NotAuthorizedException e) {
            throw new RuntimeException(e);
        }
        catch (BadRequestException e) {
            throw new RuntimeException(e);
        }
    }
}

