/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fck;

import io.milton.common.FileUtils;
import io.milton.common.Path;
import io.milton.http.FileItem;
import io.milton.http.Range;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.fck.FckCommon;
import io.milton.resource.CollectionResource;
import io.milton.resource.MakeCollectionableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FckQuickUploaderResource
extends FckCommon {
    private static final Logger log = LoggerFactory.getLogger(FckQuickUploaderResource.class);
    public static final String UPLOAD_RESPONSE_TEMPLATE_NORMAL = "<script type=\"text/javascript\">\nwindow.parent.frames['frmUpload'].OnUploadCompleted([code],'[name]') ;\n</script>\n";
    public static final Path URL = Path.path((String)"/fck_upload");
    private int code;
    private String filename;

    public FckQuickUploaderResource(CollectionResource host) {
        super(host, URL);
    }

    public String getUniqueId() {
        return "fckquickuploader";
    }

    public String processForm(Map<String, String> params, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException {
        if (files == null || files.isEmpty()) {
            log.warn("no files to upload");
            return null;
        }
        for (FileItem f : files.values()) {
            this.processFileUpload(f, params);
        }
        return null;
    }

    private void processFileUpload(FileItem f, Map<String, String> params) throws BadRequestException, NotAuthorizedException {
        String newName;
        String name;
        block20: {
            CollectionResource target = null;
            if (this.wrappedResource == null) {
                throw new BadRequestException((Resource)this, "collection not found");
            }
            target = (CollectionResource)this.wrappedResource.child("uploads");
            if (target == null) {
                try {
                    if (!(this.wrappedResource instanceof MakeCollectionableResource)) {
                        throw new BadRequestException((Resource)target, "Cant create subfolder");
                    }
                    MakeCollectionableResource mk = (MakeCollectionableResource)this.wrappedResource;
                    target = mk.createCollection("uploads");
                }
                catch (ConflictException ex) {
                    throw new RuntimeException(ex);
                }
                catch (NotAuthorizedException ex) {
                    throw new RuntimeException(ex);
                }
                catch (BadRequestException ex) {
                    throw new RuntimeException(ex);
                }
            }
            name = FileUtils.sanitiseName((String)f.getName());
            log.debug("processFileUpload: " + name);
            boolean isFirst = true;
            newName = null;
            while (target.child(name) != null) {
                newName = name = FileUtils.incrementFileName((String)name, (boolean)isFirst);
                isFirst = false;
            }
            long size = f.getSize();
            try {
                if (target instanceof PutableResource) {
                    PutableResource putable = (PutableResource)target;
                    Resource newRes = putable.createNew(name, f.getInputStream(), Long.valueOf(size), null);
                    if (newRes != null) {
                        log.trace("created: " + newRes.getName() + " of type: " + newRes.getClass());
                    } else {
                        log.trace("createNew returned null");
                    }
                    break block20;
                }
                throw new BadRequestException((Resource)target, "Does not implement PutableResource");
            }
            catch (ConflictException ex) {
                throw new RuntimeException(ex);
            }
            catch (NotAuthorizedException ex) {
                throw new RuntimeException(ex);
            }
            catch (BadRequestException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            if (newName != null) {
                this.uploadResponseOk(name);
            } else {
                this.uploadResponseOk();
            }
        }
        catch (Throwable ex) {
            log.error("Exception saving new file", ex);
            this.uploadResponseFailed(ex.getMessage());
        }
    }

    private void uploadResponseOk() {
        this.uploadResponse(0, null);
    }

    private void uploadResponseOk(String newName) {
        this.uploadResponse(201, newName);
    }

    private void uploadResponseFailed(String reason) {
        this.uploadResponse(1, reason);
    }

    private void uploadResponse(int code, String filename) {
        this.code = code;
        this.filename = filename;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException {
        String s = UPLOAD_RESPONSE_TEMPLATE_NORMAL;
        s = s.replace("[code]", this.code + "");
        String f = this.filename == null ? "" : this.filename;
        s = s.replace("[name]", f);
        out.write(s.getBytes("UTF-8"));
    }

    public String getContentType(String accepts) {
        return "text/html";
    }
}

