/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.event.Event;
import io.milton.event.GetEvent;
import io.milton.http.ExistingEntityHandler;
import io.milton.http.HttpManager;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.http.http11.MatchHelper;
import io.milton.http.http11.PartialGetHelper;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetHandler
implements ExistingEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(GetHandler.class);
    private final Http11ResponseHandler responseHandler;
    private final ResourceHandlerHelper resourceHandlerHelper;
    private final PartialGetHelper partialGetHelper;
    private final MatchHelper matchHelper;

    public GetHandler(Http11ResponseHandler responseHandler, ResourceHandlerHelper resourceHandlerHelper, MatchHelper matchHelper, PartialGetHelper partialGetHelper) {
        this.responseHandler = responseHandler;
        this.resourceHandlerHelper = resourceHandlerHelper;
        this.matchHelper = matchHelper;
        this.partialGetHelper = partialGetHelper;
    }

    @Override
    public void process(HttpManager manager, Request request, Response response) throws NotAuthorizedException, ConflictException, BadRequestException {
        log.debug("process");
        this.resourceHandlerHelper.process(manager, request, response, this);
    }

    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource r) throws NotAuthorizedException, ConflictException, BadRequestException {
        manager.onGet(request, response, r, request.getParams());
        this.resourceHandlerHelper.processResource(manager, request, response, r, this, true, request.getParams(), null);
    }

    @Override
    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException, NotFoundException {
        if (log.isTraceEnabled()) {
            log.trace("process: " + request.getAbsolutePath());
        }
        manager.getEventManager().fireEvent((Event)new GetEvent(resource));
        GetableResource r = (GetableResource)resource;
        if (this.checkConditional(r, request)) {
            if (log.isTraceEnabled()) {
                log.trace("respond not modified with: " + this.responseHandler.getClass().getCanonicalName());
            }
            this.responseHandler.respondNotModified(r, response, request);
            return;
        }
        long tm = System.currentTimeMillis();
        this.sendContent(manager, request, response, r, request.getParams());
        tm = System.currentTimeMillis() - tm;
        log.info("processExistingResource: resource={} processed in {}ms", (Object)resource, (Object)tm);
    }

    private boolean checkConditional(GetableResource resource, Request request) {
        Map params = request.getParams();
        if (params != null && !params.isEmpty()) {
            return false;
        }
        if (resource.getMaxAgeSeconds(request.getAuthorization()) == null) {
            log.trace("resource has null max age, so not modified response is disabled");
            return false;
        }
        if (this.checkIfModifiedSince(resource, request)) {
            log.trace("is not modified since");
            return true;
        }
        if (this.matchHelper.checkIfNoneMatch((Resource)resource, request)) {
            log.trace("conditional check, if-none-match returned true");
            return true;
        }
        return false;
    }

    private boolean checkIfMatch(GetableResource handler, Request requestInfo) {
        return false;
    }

    private boolean checkIfModifiedSince(GetableResource resource, Request requestInfo) {
        boolean unchangedSince;
        long timeRequestMs;
        log.trace("checkIfModifiedSince");
        Long maxAgeSecs = resource.getMaxAgeSeconds(requestInfo.getAuthorization());
        String cacheControl = requestInfo.getRequestHeader(Request.Header.CACHE_CONTROL);
        if (cacheControl != null && cacheControl.toLowerCase().equals("no-cache")) {
            return false;
        }
        if (maxAgeSecs == null) {
            log.trace("checkIfModifiedSince: null max age");
            return false;
        }
        log.trace("checkIfModifiedSince with maxAge");
        Date dtRequest = requestInfo.getIfModifiedHeader();
        if (dtRequest == null) {
            log.trace(" no modified date header");
            return false;
        }
        long timeNowMs = System.currentTimeMillis();
        long timeElapsedMs = timeNowMs - (timeRequestMs = dtRequest.getTime() + 1000L);
        long timeElapsed = timeElapsedMs / 1000L;
        if (timeElapsed > maxAgeSecs) {
            log.trace("its been longer then the max age period, so generate fresh response");
            return false;
        }
        Date dtResourceModified = resource.getModifiedDate();
        if (dtResourceModified == null) {
            if (log.isTraceEnabled()) {
                log.trace("no modified date on resource: " + resource.getClass().getCanonicalName());
            }
            return false;
        }
        long resModifiedMs = dtResourceModified.getTime();
        boolean bl = unchangedSince = timeRequestMs >= resModifiedMs;
        if (log.isTraceEnabled()) {
            log.trace("times as long: resource modified " + dtResourceModified.getTime() + " - modified since header: " + dtRequest.getTime());
            log.trace("checkModifiedSince: actual: " + dtResourceModified + " - request:" + dtRequest + " = " + unchangedSince + " (true indicates no change)");
        }
        return unchangedSince;
    }

    private boolean checkIfNoneMatch(GetableResource handler, Request requestInfo) {
        return false;
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.GET.code, Request.Method.HEAD.code};
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return handler instanceof GetableResource;
    }

    private void sendContent(HttpManager manager, Request request, Response response, GetableResource resource, Map<String, String> params) throws NotAuthorizedException, BadRequestException, NotFoundException {
        try {
            if (request.getMethod().equals((Object)Request.Method.HEAD)) {
                this.responseHandler.respondHead((Resource)resource, response, request);
            } else {
                List<Range> ranges = this.partialGetHelper.getRanges(request.getRangeHeader());
                if (ranges != null && ranges.size() > 0 && this.matchHelper.checkIfRange((Resource)resource, request)) {
                    Long contentLength = resource.getContentLength();
                    if (contentLength != null) {
                        this.partialGetHelper.sendPartialContent(resource, request, response, ranges, params, this.responseHandler);
                        return;
                    }
                    log.warn("Cant do partial GET because we don't have a content length from resource of type: " + resource.getClass() + " for url: " + request.getAbsoluteUrl());
                }
                if (log.isTraceEnabled()) {
                    log.trace("normal content: " + this.responseHandler.getClass().getCanonicalName());
                }
                this.responseHandler.respondContent((Resource)resource, response, request, params);
            }
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (NotAuthorizedException notAuthorizedException) {
            throw notAuthorizedException;
        }
        catch (BadRequestException badRequestException) {
            throw badRequestException;
        }
        catch (Throwable e) {
            log.error("Exception sending content for:" + request.getAbsolutePath() + " of resource type: " + resource.getClass().getCanonicalName(), e);
            throw new RuntimeException(e);
        }
    }
}

