/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.http.Request;
import io.milton.http.http11.ETagGenerator;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchHelper {
    private static final Logger log = LoggerFactory.getLogger(MatchHelper.class);
    private final ETagGenerator eTagGenerator;

    public MatchHelper(ETagGenerator eTagGenerator) {
        this.eTagGenerator = eTagGenerator;
    }

    public boolean checkIfMatch(Resource r, Request req) {
        if (r == null) {
            String h = req.getIfMatchHeader();
            return h == null;
        }
        Boolean result = this._checkIfMatch(r, req);
        if (result != null) {
            return result;
        }
        String value = req.getIfHeader();
        if (value == null) {
            return true;
        }
        Pattern pattern = Pattern.compile(".*\\[\"(.*)\"\\]\\)$");
        Matcher m = pattern.matcher(value);
        if (!m.matches()) {
            return true;
        }
        String etag = m.group(1);
        return this.checkIfMatch(r, etag);
    }

    private Boolean _checkIfMatch(Resource r, Request req) {
        String h = req.getIfMatchHeader();
        if (h == null || h.length() == 0) {
            return null;
        }
        if (r == null) {
            return false;
        }
        String currentEtag = this.eTagGenerator.generateEtag(r);
        if (currentEtag == null || currentEtag.length() == 0) {
            return false;
        }
        List<String> etags = this.splitToList(h);
        for (String requestedEtag : etags) {
            if (!(requestedEtag = this.cleanUp(requestedEtag)).equals(currentEtag) && !requestedEtag.equals("*")) continue;
            return true;
        }
        log.debug("Did not find matching etag");
        return false;
    }

    private boolean checkIfMatch(Resource r, String requestedEtag) {
        if (r == null) {
            return false;
        }
        String currentEtag = this.eTagGenerator.generateEtag(r);
        if (currentEtag == null || currentEtag.length() == 0) {
            return false;
        }
        return (requestedEtag = this.cleanUp(requestedEtag)).equals(currentEtag) || requestedEtag.equals("*");
    }

    public boolean checkIfNoneMatch(Resource r, Request req) {
        String h = req.getIfNoneMatchHeader();
        if (h == null) {
            return false;
        }
        if (h.equals("*")) {
            boolean b;
            boolean bl = b = r != null;
            if (r != null) {
                log.warn("if-none-match header is star, and a resource exists, so check has failed: resource name={}", (Object)r.getName());
                return true;
            }
            return b;
        }
        String currentEtag = this.eTagGenerator.generateEtag(r);
        if (currentEtag == null) {
            log.warn("Null etag for resource, so pass if-none-match test");
            return false;
        }
        List<String> etags = this.splitToList(h);
        for (String requestedEtag : etags) {
            if (!requestedEtag.equals(currentEtag)) continue;
            return true;
        }
        log.warn("None of the provided etags match, so if-none-match test passes");
        return false;
    }

    public boolean checkIfRange(Resource r, Request request) {
        String requestedEtag = request.getIfRangeHeader();
        if (requestedEtag == null || requestedEtag.trim().length() == 0) {
            return true;
        }
        String currentEtag = this.eTagGenerator.generateEtag(r);
        if (currentEtag == null || currentEtag.length() == 0) {
            return false;
        }
        return requestedEtag.equals(currentEtag) || requestedEtag.equals("*");
    }

    private List<String> splitToList(String s) {
        String[] arr = s.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String part : arr) {
            if ((part = part.trim()).length() <= 0) continue;
            list.add(part.trim());
        }
        return list;
    }

    private String cleanUp(String s) {
        s = s.replace("&quot;", "");
        s = s.replace("\"\"", "\"");
        return s;
    }
}

