/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.common.RangeUtils;
import io.milton.common.Utils;
import io.milton.http.Range;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultipleRangeWritingOutputStream
extends OutputStream {
    private final long totalResourceLength;
    private final OutputStream out;
    private final List<Range> ranges;
    private final String boundary;
    private final String contentType;
    private int currentByte;
    private Range currentRange;

    public MultipleRangeWritingOutputStream(long totalResourceLength, OutputStream out, List<Range> ranges, String boundary, String contentType) {
        this.out = out;
        this.ranges = new ArrayList<Range>(ranges);
        this.boundary = boundary;
        this.contentType = contentType;
        this.totalResourceLength = totalResourceLength;
    }

    @Override
    public void write(int b) throws IOException {
        Range range = this.getCurrentRange();
        if (range != null) {
            this.out.write(b);
        }
        ++this.currentByte;
    }

    private boolean isValid(Range r) {
        return !(r == null || r.getStart() != null && r.getStart() > (long)this.currentByte || r.getFinish() != null && r.getFinish() < (long)this.currentByte);
    }

    private boolean isBeyond(Range r) {
        return r.getFinish() != null && r.getFinish() < (long)this.currentByte;
    }

    private Range getCurrentRange() throws IOException {
        if (this.isValid(this.currentRange)) {
            return this.currentRange;
        }
        this.currentRange = null;
        Iterator<Range> i = this.ranges.iterator();
        while (i.hasNext()) {
            Range r = i.next();
            if (this.isValid(r)) {
                this.writeRangeHeader(r);
                this.currentRange = r;
                break;
            }
            if (!this.isBeyond(r)) continue;
            i.remove();
        }
        return this.currentRange;
    }

    private void writeRangeHeader(Range r) throws IOException {
        this.out.write(("\n--" + this.boundary + "\n").getBytes(Utils.UTF8));
        if (this.contentType != null) {
            this.out.write(("Content-Type: " + this.contentType + "\n").getBytes(Utils.UTF8));
        }
        this.out.write(("Content-Range: " + RangeUtils.toRangeString((long)this.currentByte, (long)r.getFinish(), (Long)this.totalResourceLength) + "\n\n").getBytes(Utils.UTF8));
    }
}

