/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import io.milton.common.Utils;
import io.milton.dns.utils.base64;
import io.milton.http.AuthenticationHandler;
import io.milton.http.BeanCookie;
import io.milton.http.Cookie;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.http11.auth.FormAuthenticationHandler;
import io.milton.http.http11.auth.HmacUtils;
import io.milton.http.http11.auth.LoginResponseHandler;
import io.milton.http.http11.auth.NonceProvider;
import io.milton.principal.DiscretePrincipal;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieAuthenticationHandler
implements AuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(CookieAuthenticationHandler.class);
    private static final String HANDLER_ATT_NAME = "_delegatedAuthenticationHandler";
    public static final int SECONDS_PER_YEAR = 31536000;
    private final String requestParamLogout = "miltonLogout";
    private final String cookieUserUrlValue = "miltonUserUrl";
    private final String cookieUserUrlHash = "miltonUserUrlHash";
    private final String loginTokenName = "loginToken";
    private final List<AuthenticationHandler> handlers;
    private final ResourceFactory principalResourceFactory;
    private final NonceProvider nonceProvider;
    private String userUrlAttName = "userUrl";
    private boolean useLongLivedCookies = true;
    private final List<String> keys;
    private String keepLoggedInParamName = "keepLoggedIn";

    public CookieAuthenticationHandler(NonceProvider nonceProvider, List<AuthenticationHandler> handlers, ResourceFactory principalResourceFactory, List<String> keys) {
        this.nonceProvider = nonceProvider;
        this.handlers = handlers;
        this.principalResourceFactory = principalResourceFactory;
        this.keys = keys;
    }

    @Override
    public boolean credentialsPresent(Request request) {
        String userUrl = this.getUserUrlFromRequest(request);
        if (userUrl != null && userUrl.length() > 0) {
            return true;
        }
        for (AuthenticationHandler h : this.handlers) {
            if (!h.credentialsPresent(request)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(Resource r, Request request) {
        if (this.isLogout(request)) {
            String userUrl = this.getUserUrl(request);
            log.info("Is LogOut request, clear cookie");
            if (userUrl != null && userUrl.length() > 0) {
                this.clearCookieValue(HttpManager.response());
            }
        }
        ArrayList<AuthenticationHandler> supportingHandlers = new ArrayList<AuthenticationHandler>();
        for (AuthenticationHandler hnd : this.handlers) {
            if (!hnd.supports(r, request)) continue;
            log.info("Found child handler who supports this request {}", (Object)hnd);
            supportingHandlers.add(hnd);
        }
        if (!supportingHandlers.isEmpty()) {
            request.getAttributes().put(HANDLER_ATT_NAME, supportingHandlers);
            return true;
        }
        String userUrl = this.getUserUrl(request);
        return userUrl != null;
    }

    @Override
    public Object authenticate(Resource resource, Request request) {
        Resource r;
        List supportingHandlers = (List)request.getAttributes().get(HANDLER_ATT_NAME);
        if (supportingHandlers != null && !supportingHandlers.isEmpty()) {
            DiscretePrincipal lastUser = null;
            for (AuthenticationHandler delegateHandler : supportingHandlers) {
                Object tag;
                if (log.isTraceEnabled()) {
                    log.trace("authenticate: use delegateHandler: " + delegateHandler);
                }
                if ((tag = delegateHandler.authenticate(resource, request)) != null) {
                    if (tag instanceof DiscretePrincipal) {
                        lastUser = (DiscretePrincipal)tag;
                        this.setLoginCookies(lastUser, request);
                        log.trace("authenticate: authentication passed by delegated handler, persisted userUrl to cookie");
                    } else {
                        log.warn("authenticate: auth.tag is not an instance of " + DiscretePrincipal.class + ", is: " + tag.getClass() + " so is not compatible with cookie authentication");
                        if (delegateHandler instanceof FormAuthenticationHandler) {
                            LoginResponseHandler.setDisableHtmlResponse(request);
                            return null;
                        }
                    }
                    return tag;
                }
                log.info("Login failed by delegated handler: " + delegateHandler.getClass());
            }
            return lastUser;
        }
        log.trace("no delegating handler");
        if (this.isLogout(request)) {
            log.trace("authenticate: is logout");
            return null;
        }
        String userUrl = this.getUserUrl(request);
        if (userUrl == null) {
            log.trace("authenticate: no userUrl in request or cookie, nothing to do");
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("authenticate: userUrl=" + userUrl);
        }
        String host = request.getHostHeader();
        try {
            r = this.principalResourceFactory.getResource(host, userUrl);
            log.trace("found current user: " + r);
        }
        catch (NotAuthorizedException ex) {
            log.error("Couldnt check userUrl in cookie", (Throwable)ex);
            r = null;
        }
        catch (BadRequestException ex) {
            log.error("Couldnt check userUrl in cookie", (Throwable)ex);
            r = null;
        }
        if (r == null) {
            log.warn("User not found host: " + host + " userUrl: " + userUrl + " with resourcefactory: " + this.principalResourceFactory);
            this.clearCookieValue(HttpManager.response());
        } else if (request.getParams() != null && (request.getParams().containsKey("miltonUserUrl") || request.getParams().containsKey("loginToken"))) {
            if (r instanceof DiscretePrincipal) {
                DiscretePrincipal dp = (DiscretePrincipal)r;
                this.setLoginCookies(dp, request);
            } else {
                log.warn("Found user from request, but user object is not expected type. Should be " + DiscretePrincipal.class + " but is " + r.getClass());
            }
        } else {
            log.trace("Do not set cookies, because token did not come from request variable");
        }
        return r;
    }

    public void setLoginCookies(DiscretePrincipal user, Request request) {
        log.trace("setLoginCookies");
        if (user == null) {
            throw new NullPointerException("user object is null");
        }
        if (user.getIdenitifer() == null) {
            throw new NullPointerException("getIdenitifer object is null");
        }
        String userUrl = user.getIdenitifer().getValue();
        if (userUrl == null) {
            throw new NullPointerException("user identifier returned a null value");
        }
        this.setLoginCookies(userUrl, request);
    }

    public void setLoginCookies(String userUrl, Request request) {
        if (request == null) {
            return;
        }
        Response response = HttpManager.response();
        if (response == null) {
            log.trace("setLoginCookies: No response object");
            return;
        }
        String signing = this.getUrlSigningHash(userUrl, request);
        String sKeepLoggedIn = null;
        if (request.getParams() != null) {
            sKeepLoggedIn = (String)request.getParams().get(this.keepLoggedInParamName);
        }
        boolean keepLoggedIn = sKeepLoggedIn != null ? sKeepLoggedIn.equalsIgnoreCase("true") : true;
        this.setCookieValues(response, userUrl, signing, keepLoggedIn);
        request.getAttributes().put(this.userUrlAttName, userUrl);
    }

    @Override
    public void appendChallenges(Resource resource, Request request, List<String> challenges) {
        for (AuthenticationHandler h : this.handlers) {
            if (!h.isCompatible(resource, request)) continue;
            h.appendChallenges(resource, request, challenges);
        }
    }

    @Override
    public boolean isCompatible(Resource resource, Request request) {
        for (AuthenticationHandler h : this.handlers) {
            if (!h.isCompatible(resource, request)) continue;
            return true;
        }
        return false;
    }

    private boolean isLogout(Request request) {
        if (request.getParams() == null) {
            return false;
        }
        String logoutCommand = (String)request.getParams().get("miltonLogout");
        return logoutCommand != null && logoutCommand.length() > 0;
    }

    public String getUserUrl(Request request) {
        if (request == null) {
            return null;
        }
        String userUrl = this.getUserUrlFromRequest(request);
        if (userUrl != null && (userUrl = userUrl.trim()).length() > 0) {
            if (this.verifyHash(userUrl, request)) {
                return userUrl;
            }
            log.info("Invalid userUrl hash, possible attempted hacking attempt. userUrl=" + userUrl);
        }
        return null;
    }

    public String getUserUrlFromRequest(Request request) {
        byte[] arr;
        String encodedUserUrl = null;
        String lt = this.getCookieOrParam(request, "loginToken");
        if (lt != null) {
            byte[] raw = base64.fromString(lt);
            String params = new String(raw);
            if (params.contains("|")) {
                String[] parts = params.split("\\|");
                if (parts.length == 2) {
                    encodedUserUrl = parts[0];
                    request.getAttributes().put("miltonUserUrlHash", parts[1]);
                } else {
                    log.warn("getUserUrlFromRequest: loginToken is invalid: {}", (Object)params);
                }
            } else {
                log.warn("getUserUrlFromRequest: loginToken is invalid: {}", (Object)params);
            }
        }
        if (encodedUserUrl == null) {
            encodedUserUrl = this.getCookieOrParam(request, "miltonUserUrl");
        }
        if (encodedUserUrl == null) {
            log.trace("getUserUrlFromRequest: Null encodedUserUrl");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("getUserUrlFromRequest: Raw:" + encodedUserUrl);
        }
        if (!encodedUserUrl.startsWith("b64")) {
            log.trace("Looks like a plain path, return as is");
            return encodedUserUrl;
        }
        log.trace("Looks like a base64 encoded string");
        encodedUserUrl = encodedUserUrl.substring(3);
        encodedUserUrl = Utils.decodePath((String)encodedUserUrl);
        if (log.isDebugEnabled()) {
            log.debug("getUserUrlFromRequest: Percent decoded:" + encodedUserUrl);
        }
        if ((arr = base64.fromString(encodedUserUrl)) == null) {
            log.debug("Failed to decode encodedUserUrl, so maybe its not encoded, return as it is");
            return encodedUserUrl;
        }
        String s = new String(arr);
        if (log.isDebugEnabled()) {
            log.debug("getUserUrlFromRequest: Decoded user url:" + s);
        }
        return s;
    }

    public String getHashFromRequest(Request request) {
        String signing = this.getParamVal(request, "miltonUserUrlHash");
        if (signing == null) {
            String lt;
            if (request.getAttributes().containsKey("miltonUserUrlHash")) {
                signing = (String)request.getAttributes().get("miltonUserUrlHash");
            }
            if (signing == null && (lt = this.getCookieOrParam(request, "loginToken")) != null) {
                byte[] raw = base64.fromString(lt);
                String params = new String(raw);
                if (params.contains("|")) {
                    String[] parts = params.split("\\|");
                    if (parts.length == 2) {
                        signing = parts[1];
                    } else {
                        log.warn("getHashFromRequest: loginToken is invalid: {}", (Object)params);
                    }
                } else {
                    log.warn("getHashFromRequest: loginToken is invalid: {}", (Object)params);
                }
            }
        }
        if (signing == null) {
            signing = this.getCookieOrParam(request, "miltonUserUrlHash");
        }
        return signing;
    }

    private boolean verifyHash(String userUrl, Request request) {
        String signing = this.getHashFromRequest(request);
        if (signing == null) {
            return false;
        }
        signing = signing.replace("\"", "");
        if ((signing = signing.trim()).length() == 0) {
            log.warn("cookie signature is not present in cookie: miltonUserUrlHash");
            return false;
        }
        for (String key : this.keys) {
            if (key == null || key.length() <= 0 || !this.verifyHash(userUrl, key, signing, request)) continue;
            return true;
        }
        return false;
    }

    private boolean verifyHash(String userUrl, String key, String signing, Request request) {
        boolean ok;
        int pos = signing.indexOf(":");
        if (pos < 1) {
            log.warn("Invalid cookie signing format, no semi-colon: " + signing + " Should be in form - nonce:hmac");
            return false;
        }
        String host = this.getDomain(request);
        String nonce = signing.substring(0, pos);
        String hmac = signing.substring(pos + 1);
        String message = nonce + ":" + userUrl + ":" + host;
        String expectedHmac = HmacUtils.calcShaHash(message, key);
        if (log.isTraceEnabled()) {
            log.trace("Message:" + message);
            log.trace("Key:" + key);
            log.trace("Hash:" + expectedHmac);
            log.trace("Given Signing:" + signing);
        }
        if (!(ok = expectedHmac.equals(hmac))) {
            if (log.isDebugEnabled()) {
                log.debug("Cookie sig does not match expected. Given=" + hmac + " Expected=" + expectedHmac);
            }
            return false;
        }
        NonceProvider.NonceValidity val = this.nonceProvider.getNonceValidity(nonce, null, userUrl);
        if (val == null) {
            throw new RuntimeException("Unhandled nonce validity value");
        }
        switch (val) {
            case OK: {
                return true;
            }
            case EXPIRED: {
                log.warn("Nonce is valid, but expired. We will accept it but reset it");
                this.setLoginCookies(userUrl, request);
                return true;
            }
            case INVALID: {
                log.warn("Received an invalid nonce: " + nonce + " not found in provider: " + this.nonceProvider);
                return false;
            }
        }
        throw new RuntimeException("Unhandled nonce validity value");
    }

    private String getDomain(Request request) {
        String host = request.getHostHeader();
        if (host.contains(":")) {
            host = host.substring(0, host.indexOf(":"));
        }
        if (host == null) {
            host = "nohost";
        }
        return host;
    }

    public String getUrlSigningHash(String userUrl, Request request) {
        String host = this.getDomain(request);
        return this.getUrlSigningHash(userUrl, request, host);
    }

    public String getUrlSigningHash(String userUrl, Request request, String host) {
        String nonce = this.nonceProvider.createNonce(request, userUrl);
        String message = nonce + ":" + userUrl + ":" + host;
        String key = this.keys.get(this.keys.size() - 1);
        String hash = HmacUtils.calcShaHash(message, key);
        String signing = nonce + ":" + hash;
        if (log.isTraceEnabled()) {
            log.trace("Message:" + message);
            log.trace("Key:" + key);
            log.trace("Hash:" + hash);
            log.trace("Signing:" + signing);
        }
        return signing;
    }

    public String getLoginToken(String userUrl, Request request) {
        String host = this.getDomain(request);
        return this.getLoginToken(userUrl, request, host);
    }

    public String getLoginToken(String userUrl, Request request, String host) {
        String hash = this.getUrlSigningHash(userUrl, request, host);
        return this.getLoginToken(userUrl, hash);
    }

    public String getLoginToken(String userUrl, String urlSigningHash) {
        String s = userUrl + '|' + urlSigningHash;
        return base64.toString(s.getBytes());
    }

    private void setCookieValues(Response response, String userUrl, String hash, boolean keepLoggedIn) {
        log.trace("setCookieValues");
        BeanCookie c = new BeanCookie("miltonUserUrl");
        String encodedUserUrl = this.encodeUserUrl(userUrl);
        c.setValue(encodedUserUrl);
        c.setPath("/");
        c.setVersion(1);
        if (keepLoggedIn && this.useLongLivedCookies) {
            c.setExpiry(31536000);
        }
        response.setCookie((Cookie)c);
        c = new BeanCookie("miltonUserUrlHash");
        c.setValue("\"" + hash + "\"");
        c.setHttpOnly(true);
        c.setVersion(1);
        c.setPath("/");
        if (keepLoggedIn && this.useLongLivedCookies) {
            c.setExpiry(31536000);
        }
        response.setCookie((Cookie)c);
    }

    public String encodeUserUrl(String userUrl) {
        String encodedUserUrl = base64.toString(userUrl.getBytes(Utils.UTF8));
        encodedUserUrl = Utils.percentEncode((String)encodedUserUrl);
        encodedUserUrl = "b64" + encodedUserUrl;
        return encodedUserUrl;
    }

    private void clearCookieValue(Response response) {
        log.info("clearCookieValue");
        response.setCookie("miltonUserUrl", "");
        response.setCookie("miltonUserUrlHash", "");
    }

    private String getCookieOrParam(Request request, String name) {
        String v;
        if (request == null) {
            return null;
        }
        if (request.getParams() != null && (v = (String)request.getParams().get(name)) != null) {
            return v;
        }
        Cookie c = request.getCookie(name);
        if (c != null) {
            return c.getValue();
        }
        return null;
    }

    private String getParamVal(Request request, String name) {
        String v;
        if (request.getParams() != null && (v = (String)request.getParams().get(name)) != null) {
            return v;
        }
        return null;
    }

    public String getCookieNameUserUrlHash() {
        return "miltonUserUrlHash";
    }

    public String getCookieNameUserUrl() {
        return "miltonUserUrl";
    }

    public String getUserUrlAttName() {
        return this.userUrlAttName;
    }

    public String getLoginTokenName() {
        return "loginToken";
    }

    public void setUserUrlAttName(String userUrlAttName) {
        this.userUrlAttName = userUrlAttName;
    }

    public void setUseLongLivedCookies(boolean useLongLivedCookies) {
        this.useLongLivedCookies = useLongLivedCookies;
    }

    public boolean isUseLongLivedCookies() {
        return this.useLongLivedCookies;
    }
}

