/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import io.milton.http.Auth;
import io.milton.http.AuthenticationHandler;
import io.milton.http.Request;
import io.milton.http.SecurityManager;
import io.milton.resource.Resource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityManagerBasicAuthHandler
implements AuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(SecurityManagerBasicAuthHandler.class);
    private final SecurityManager securityManager;

    public SecurityManagerBasicAuthHandler(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    @Override
    public boolean credentialsPresent(Request request) {
        return request.getAuthorization() != null;
    }

    @Override
    public boolean supports(Resource r, Request request) {
        Auth auth = request.getAuthorization();
        if (auth == null) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("supports basic? requested scheme: " + auth.getScheme());
        }
        return auth.getScheme().equals((Object)Auth.Scheme.BASIC);
    }

    @Override
    public Object authenticate(Resource resource, Request request) {
        log.debug("authenticate");
        Auth auth = request.getAuthorization();
        Object o = this.securityManager.authenticate(auth.getUser(), auth.getPassword());
        log.debug("result: " + o);
        return o;
    }

    @Override
    public void appendChallenges(Resource resource, Request request, List<String> challenges) {
        String realm = this.securityManager.getRealm(request.getHostHeader());
        challenges.add("Basic realm=\"" + realm + "\"");
    }

    @Override
    public boolean isCompatible(Resource resource, Request request) {
        return true;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }
}

