/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.json;

import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.http11.auth.DigestResponse;
import io.milton.resource.DigestResource;
import io.milton.resource.Resource;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonResource
implements DigestResource {
    private static final Logger log = LoggerFactory.getLogger(JsonResource.class);
    public static String CONTENT_TYPE = "application/json; charset=utf-8";
    private final Resource wrappedResource;
    private final String name;
    private final Long maxAgeSecs;

    public abstract Request.Method applicableMethod();

    public JsonResource(Resource wrappedResource, String name, Long maxAgeSecs) {
        this.wrappedResource = wrappedResource;
        this.name = name;
        this.maxAgeSecs = maxAgeSecs;
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return this.maxAgeSecs;
    }

    public String getContentType(String accepts) {
        return CONTENT_TYPE;
    }

    public Long getContentLength() {
        return null;
    }

    public String getUniqueId() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Object authenticate(String user, String password) {
        if (log.isDebugEnabled()) {
            log.debug("authenticate: " + user);
        }
        Object o = this.wrappedResource.authenticate(user, password);
        if (log.isDebugEnabled() && o == null) {
            log.debug("authentication failed on wrapped resource of type: " + this.wrappedResource.getClass());
        }
        return o;
    }

    public Object authenticate(DigestResponse digestRequest) {
        if (this.wrappedResource instanceof DigestResource) {
            return ((DigestResource)this.wrappedResource).authenticate(digestRequest);
        }
        return null;
    }

    public boolean isDigestAllowed() {
        return this.wrappedResource instanceof DigestResource;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        boolean b = this.wrappedResource.authorise(request, this.applicableMethod(), auth);
        if (log.isDebugEnabled()) {
            if (!b) {
                log.trace("authorise failed on wrapped resource of type: " + this.wrappedResource.getClass());
            } else {
                log.trace("all ok");
            }
        }
        return b;
    }

    public String getRealm() {
        return this.wrappedResource.getRealm();
    }

    public Date getModifiedDate() {
        return null;
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public Resource getWrappedResource() {
        return this.wrappedResource;
    }
}

