/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.json;

import io.milton.http.Auth;
import io.milton.http.HttpManager;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.json.JsonPropFindHandler;
import io.milton.http.json.JsonResource;
import io.milton.resource.GetableResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropFindJsonResource
extends JsonResource
implements GetableResource {
    private static final Logger log = LoggerFactory.getLogger(PropFindJsonResource.class);
    private final PropFindableResource wrappedResource;
    private final JsonPropFindHandler jsonPropFindHandler;
    private final String encodedUrl;

    public PropFindJsonResource(PropFindableResource wrappedResource, JsonPropFindHandler jsonPropFindHandler, String encodedUrl, Long maxAgeSecs) {
        super((Resource)wrappedResource, Request.Method.PROPFIND.code, maxAgeSecs);
        this.wrappedResource = wrappedResource;
        this.encodedUrl = encodedUrl;
        this.jsonPropFindHandler = jsonPropFindHandler;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
        this.jsonPropFindHandler.sendContent(this.wrappedResource, this.encodedUrl, out, range, params, contentType);
    }

    @Override
    public Request.Method applicableMethod() {
        return Request.Method.PROPFIND;
    }

    @Override
    public Long getMaxAgeSeconds(Auth auth) {
        String sMaxAge;
        Request req = HttpManager.request();
        if (req != null && (sMaxAge = (String)req.getParams().get("maxAgeSecs")) != null && sMaxAge.length() > 0) {
            try {
                log.trace("using max age from parameter");
                Long maxAge = Long.parseLong(sMaxAge);
                return maxAge;
            }
            catch (NumberFormatException e) {
                log.debug("Couldnt parse max age parameter: " + sMaxAge);
            }
        }
        return super.getMaxAgeSeconds(auth);
    }
}

