/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.common.ReadingException;
import io.milton.common.StreamUtils;
import io.milton.common.WritingException;
import io.milton.http.webdav.PropPatchParseResult;
import io.milton.http.webdav.PropPatchRequestParser;
import io.milton.http.webdav.PropPatchSaxHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DefaultPropPatchParser
implements PropPatchRequestParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultPropPatchParser.class);

    @Override
    public PropPatchParseResult getRequestedFields(InputStream in) {
        log.debug("getRequestedFields");
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            StreamUtils.readTo((InputStream)in, (OutputStream)bout, (boolean)false, (boolean)true);
            byte[] arr = bout.toByteArray();
            return this.parseContent(arr);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
        catch (ReadingException ex) {
            throw new RuntimeException(ex);
        }
        catch (WritingException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private PropPatchParseResult parseContent(byte[] arr) throws IOException, SAXException {
        if (arr.length > 0) {
            log.debug("processing content");
            ByteArrayInputStream bin = new ByteArrayInputStream(arr);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            PropPatchSaxHandler handler = new PropPatchSaxHandler();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(bin));
            log.debug("toset: " + handler.getAttributesToSet().size());
            return new PropPatchParseResult(handler.getAttributesToSet(), handler.getAttributesToRemove().keySet());
        }
        log.debug("empty content");
        return new PropPatchParseResult(new HashMap(), new HashSet());
    }
}

