/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.common.Utils;
import io.milton.event.AfterMoveEvent;
import io.milton.event.Event;
import io.milton.event.MoveEvent;
import io.milton.http.DeleteHelper;
import io.milton.http.DeleteHelperImpl;
import io.milton.http.ExistingEntityHandler;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.webdav.Dest;
import io.milton.http.webdav.UserAgentHelper;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.CollectionResource;
import io.milton.resource.DeletableResource;
import io.milton.resource.MoveableResource;
import io.milton.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveHandler
implements ExistingEntityHandler {
    private final Logger log = LoggerFactory.getLogger(MoveHandler.class);
    private final WebDavResponseHandler responseHandler;
    private final ResourceHandlerHelper resourceHandlerHelper;
    private final HandlerHelper handlerHelper;
    private final UserAgentHelper userAgentHelper;
    private DeleteHelper deleteHelper;
    private boolean deleteExistingBeforeMove = true;

    public MoveHandler(WebDavResponseHandler responseHandler, HandlerHelper handlerHelper, ResourceHandlerHelper resourceHandlerHelper, UserAgentHelper userAgentHelper) {
        this.userAgentHelper = userAgentHelper;
        this.responseHandler = responseHandler;
        this.resourceHandlerHelper = resourceHandlerHelper;
        this.handlerHelper = handlerHelper;
        this.deleteHelper = new DeleteHelperImpl(handlerHelper);
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.MOVE.code};
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return handler instanceof MoveableResource;
    }

    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource r) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.resourceHandlerHelper.processResource(manager, request, response, r, this);
    }

    @Override
    public void process(HttpManager httpManager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.resourceHandlerHelper.process(httpManager, request, response, this);
    }

    @Override
    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException {
        MoveableResource r = (MoveableResource)resource;
        Dest dest = Utils.getDecodedDestination((String)request.getDestinationHeader());
        Resource rDest = manager.getResourceFactory().getResource(dest.host, dest.url);
        this.log.debug("process: moving from: " + r.getName() + " -> " + dest.url + " with name: " + dest.name);
        if (rDest == null) {
            this.log.debug("process: destination parent does not exist: " + dest);
            this.responseHandler.respondConflict(resource, response, request, "Destination parent does not exist: " + dest);
        } else if (!(rDest instanceof CollectionResource)) {
            this.log.debug("process: destination exists but is not a collection");
            this.responseHandler.respondConflict(resource, response, request, "Destination exists but is not a collection: " + dest);
        } else {
            boolean wasDeleted = false;
            CollectionResource colDest = (CollectionResource)rDest;
            Resource rExisting = colDest.child(dest.name);
            if (rExisting != null) {
                if (!this.canOverwrite(request)) {
                    this.log.info("destination resource exists, and overwrite header is not set. dest name: " + dest.name + " dest folder: " + colDest.getName());
                    this.responseHandler.respondPreconditionFailed(request, response, rExisting);
                    return;
                }
                if (this.deleteExistingBeforeMove) {
                    if (rExisting instanceof DeletableResource) {
                        this.log.debug("deleting existing resource");
                        DeletableResource drExisting = (DeletableResource)rExisting;
                        if (this.deleteHelper.isLockedOut(request, (Resource)drExisting)) {
                            this.log.debug("destination resource exists but is locked");
                            this.responseHandler.respondLocked(request, response, (Resource)drExisting);
                            return;
                        }
                        this.log.debug("deleting pre-existing destination resource");
                        this.deleteHelper.delete(drExisting, manager.getEventManager());
                        wasDeleted = true;
                    } else {
                        this.log.warn("destination exists, and overwrite header is set, but destination is not a DeletableResource");
                        this.responseHandler.respondConflict(resource, response, request, "A resource exists at the destination, and it cannot be deleted");
                        return;
                    }
                }
            }
            this.log.debug("process: moving resource to: " + rDest.getName());
            try {
                if (!this.handlerHelper.checkAuthorisation(manager, (Resource)colDest, request, request.getMethod(), request.getAuthorization())) {
                    this.responseHandler.respondUnauthorised((Resource)colDest, response, request);
                    return;
                }
                manager.getEventManager().fireEvent((Event)new MoveEvent(resource, colDest, dest.name));
                r.moveTo(colDest, dest.name);
                manager.getEventManager().fireEvent((Event)new AfterMoveEvent(resource, colDest, dest.name));
                if (wasDeleted) {
                    this.responseHandler.respondNoContent(resource, response, request);
                } else {
                    this.responseHandler.respondCreated(resource, response, request);
                }
            }
            catch (ConflictException ex) {
                this.log.warn("conflict", (Throwable)ex);
                this.responseHandler.respondConflict(resource, response, request, dest.toString());
            }
        }
        this.log.debug("process: finished");
    }

    private boolean canOverwrite(Request request) {
        boolean bHasOverwriteHeader;
        Boolean ow = request.getOverwriteHeader();
        boolean bl = bHasOverwriteHeader = ow != null && request.getOverwriteHeader() != false;
        if (bHasOverwriteHeader) {
            return true;
        }
        if (this.userAgentHelper.isMacFinder(request)) {
            this.log.debug("no overwrite header, but user agent is Finder so permit overwrite");
            return true;
        }
        return false;
    }

    public UserAgentHelper getUserAgentHelper() {
        return this.userAgentHelper;
    }

    public DeleteHelper getDeleteHelper() {
        return this.deleteHelper;
    }

    public void setDeleteHelper(DeleteHelper deleteHelper) {
        this.deleteHelper = deleteHelper;
    }

    public void setDeleteExistingBeforeMove(boolean deleteExistingBeforeCopy) {
        this.deleteExistingBeforeMove = deleteExistingBeforeCopy;
    }

    public boolean isDeleteExistingBeforeMove() {
        return this.deleteExistingBeforeMove;
    }
}

