/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.BerEncoder;
import io.milton.common.LogUtils;
import io.milton.ldap.Ldap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(LdapResponseHandler.class);
    final BerEncoder responseBer = new BerEncoder();
    private final Socket client;
    private final OutputStream os;
    int ldapVersion = 3;
    private String currentHostName;

    public LdapResponseHandler(Socket client, OutputStream os) {
        this.client = client;
        this.os = os;
    }

    public boolean isLdapV3() {
        return this.ldapVersion == 3;
    }

    public void sendRootDSE(int currentMessageId) throws IOException {
        log.debug("LOG_LDAP_SEND_ROOT_DSE");
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("objectClass", "top");
        attributes.put("namingContexts", Ldap.NAMING_CONTEXTS);
        this.sendEntry(currentMessageId, "Root DSE", attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEntry(int currentMessageId, String dn, Map<String, Object> attributes) throws IOException {
        LogUtils.trace((Logger)log, (Object[])new Object[]{"sendEntry", currentMessageId, dn, attributes.size()});
        BerEncoder berEncoder = this.responseBer;
        synchronized (berEncoder) {
            this.responseBer.reset();
            this.responseBer.beginSeq(48);
            this.responseBer.encodeInt(currentMessageId);
            this.responseBer.beginSeq(100);
            this.responseBer.encodeString(dn, this.isLdapV3());
            this.responseBer.beginSeq(48);
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                this.responseBer.beginSeq(48);
                this.responseBer.encodeString(entry.getKey(), this.isLdapV3());
                this.responseBer.beginSeq(49);
                Object values = entry.getValue();
                if (values instanceof String) {
                    this.responseBer.encodeString((String)values, this.isLdapV3());
                } else if (values instanceof List) {
                    for (Object value : (List)values) {
                        this.responseBer.encodeString((String)value, this.isLdapV3());
                    }
                } else {
                    throw new RuntimeException("EXCEPTION_UNSUPPORTED_VALUE: " + values);
                }
                this.responseBer.endSeq();
                this.responseBer.endSeq();
            }
            this.responseBer.endSeq();
            this.responseBer.endSeq();
            this.responseBer.endSeq();
            this.sendResponse();
        }
    }

    public void sendErr(int currentMessageId, int responseOperation, Exception e) throws IOException {
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        this.sendClient(currentMessageId, responseOperation, 80, message);
    }

    public void sendClient(int currentMessageId, int responseOperation, int status, String message) throws IOException {
        this.responseBer.reset();
        this.responseBer.beginSeq(48);
        this.responseBer.encodeInt(currentMessageId);
        this.responseBer.beginSeq(responseOperation);
        this.responseBer.encodeInt(status, 10);
        this.responseBer.encodeString("", this.isLdapV3());
        this.responseBer.encodeString(message, this.isLdapV3());
        this.responseBer.endSeq();
        this.responseBer.endSeq();
        this.sendResponse();
    }

    public void sendResponse() throws IOException {
        this.os.write(this.responseBer.getBuf(), 0, this.responseBer.getDataLen());
        this.os.flush();
    }

    void setVersion(int v) {
        this.ldapVersion = v;
    }

    public void sendBaseContext(int currentMessageId) throws IOException {
        ArrayList<String> objectClasses = new ArrayList<String>();
        objectClasses.add("top");
        objectClasses.add("organizationalUnit");
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("objectClass", objectClasses);
        attributes.put("description", "Milton LDAP Gateway");
        this.sendEntry(currentMessageId, "ou=people", attributes);
    }

    public void sendComputerContext(int currentMessageId, Set<String> returningAttributes) throws IOException {
        ArrayList<String> objectClasses = new ArrayList<String>();
        objectClasses.add("top");
        objectClasses.add("apple-computer");
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.addIf(attributes, returningAttributes, "objectClass", objectClasses);
        this.addIf(attributes, returningAttributes, "apple-generateduid", "52486C30-F0AB-48E3-9C37-37E9B28CDD7B");
        this.addIf(attributes, returningAttributes, "apple-serviceinfo", this.getServiceInfo());
        this.addIf(attributes, returningAttributes, "apple-xmlplist", this.getServiceInfo());
        this.addIf(attributes, returningAttributes, "apple-serviceslocator", "::anyService");
        this.addIf(attributes, returningAttributes, "cn", this.getCurrentHostName());
        String dn = "cn=" + this.getCurrentHostName() + ", " + "cn=computers, o=od";
        log.debug("LOG_LDAP_SEND_COMPUTER_CONTEXT", (Object)dn, attributes);
        this.sendEntry(currentMessageId, dn, attributes);
    }

    protected String getServiceInfo() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version='1.0' encoding='UTF-8'?><!DOCTYPE plist PUBLIC '-//Apple//DTD PLIST 1.0//EN' 'http://www.apple.com/DTDs/PropertyList-1.0.dtd'><plist version='1.0'><dict><key>com.apple.macosxserver.host</key><array><string>localhost</string></array><key>com.apple.macosxserver.virtualhosts</key><dict><key>D6DD8A10-1098-11DE-8C30-0800200C9A66</key><dict><key>hostDetails</key><dict><key>http</key><dict><key>enabled</key><true/></dict><key>https</key><dict><key>disabled</key><false/><key>port</key><integer>0</integer></dict></dict><key>hostname</key><string>");
        try {
            buffer.append(this.getCurrentHostName());
        }
        catch (UnknownHostException ex) {
            buffer.append("Unknown host");
        }
        buffer.append("</string><key>serviceInfo</key><dict><key>calendar</key><dict><key>enabled</key><true/><key>templates</key><dict><key>calendarUserAddresses</key><array><string>%(principaluri)s</string><string>mailto:%(email)s</string><string>urn:uuid:%(guid)s</string></array><key>principalPath</key><string>/principals/__uuids__/%(guid)s/</string></dict></dict></dict><key>serviceType</key><array><string>calendar</string></array></dict></dict></dict></plist>");
        return buffer.toString();
    }

    protected String getCurrentHostName() throws UnknownHostException {
        if (this.currentHostName == null) {
            this.currentHostName = this.client.getInetAddress().isLoopbackAddress() ? "localhost" : InetAddress.getLocalHost().getCanonicalHostName();
        }
        return this.currentHostName;
    }

    public void dumpBer(byte[] inbuf, int offset) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Ber.dumpBER(baos, "LDAP request buffer\n", inbuf, 0, offset);
        try {
            log.debug(new String(baos.toByteArray(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
    }

    protected void addIf(Map<String, Object> attributes, Set<String> returningAttributes, String name, Object value) {
        if (returningAttributes.isEmpty() || returningAttributes.contains(name)) {
            attributes.put(name, value);
        }
    }

    public void sendBindResponse(int currentMessageId, int status, byte[] serverResponse) throws IOException {
        this.responseBer.beginSeq(48);
        this.responseBer.encodeInt(currentMessageId);
        this.responseBer.beginSeq(97);
        this.responseBer.encodeInt(status, 10);
        this.responseBer.encodeString("", this.isLdapV3());
        this.responseBer.encodeString("", this.isLdapV3());
        if (serverResponse != null) {
            this.responseBer.encodeOctetString(serverResponse, 135);
        }
        this.responseBer.endSeq();
        this.responseBer.endSeq();
        this.sendResponse();
    }
}

