/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import io.milton.common.LogUtils;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.ldap.Condition;
import io.milton.ldap.Conditions;
import io.milton.ldap.LdapFilter;
import io.milton.ldap.LdapPrincipal;
import io.milton.ldap.LdapPropertyMapper;
import io.milton.ldap.UserFactory;
import io.milton.resource.LdapContact;
import io.milton.resource.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleLdapFilter
implements LdapFilter {
    private static final Logger log = LoggerFactory.getLogger(SimpleLdapFilter.class);
    private final UserFactory userFactory;
    private final LdapPropertyMapper propertyMapper;
    private final Conditions conditions;
    static final String STAR = "*";
    final String attributeName;
    final String value;
    final int mode;
    final int operator;
    final boolean canIgnore;

    SimpleLdapFilter(LdapPropertyMapper propertyMapper, UserFactory userFactory, String attributeName) {
        this.userFactory = userFactory;
        this.propertyMapper = propertyMapper;
        this.conditions = new Conditions(propertyMapper);
        this.attributeName = attributeName;
        this.value = STAR;
        this.operator = 164;
        this.mode = 0;
        this.canIgnore = this.checkIgnore();
    }

    SimpleLdapFilter(LdapPropertyMapper propertyMapper, UserFactory userFactory, String attributeName, String value, int ldapFilterOperator, int ldapFilterMode) {
        this.userFactory = userFactory;
        this.propertyMapper = propertyMapper;
        this.conditions = new Conditions(propertyMapper);
        this.attributeName = attributeName;
        this.value = value;
        this.operator = ldapFilterOperator;
        this.mode = ldapFilterMode;
        this.canIgnore = this.checkIgnore();
    }

    private boolean checkIgnore() {
        return "objectclass".equals(this.attributeName) && STAR.equals(this.value);
    }

    @Override
    public boolean isFullSearch() {
        return "objectclass".equals(this.attributeName) && STAR.equals(this.value);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        buffer.append(this.attributeName);
        buffer.append('=');
        if (STAR.equals(this.value)) {
            buffer.append(STAR);
        } else if (this.operator == 164) {
            if (this.mode == 130 || this.mode == 129) {
                buffer.append(STAR);
            }
            buffer.append(this.value);
            if (this.mode == 128 || this.mode == 129) {
                buffer.append(STAR);
            }
        } else {
            buffer.append(this.value);
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public Condition getContactSearchFilter() {
        String contactAttributeName = this.attributeName;
        if (this.canIgnore || contactAttributeName == null) {
            return null;
        }
        Condition condition = null;
        if (this.operator == 163) {
            LogUtils.debug((Logger)log, (Object[])new Object[]{"getContactSearchFilter: equality", this.value});
            condition = this.conditions.isEqualTo(contactAttributeName, this.value);
        } else if (STAR.equals(this.value)) {
            LogUtils.debug((Logger)log, (Object[])new Object[]{"getContactSearchFilter: *"});
            condition = this.conditions.not(this.conditions.isNull(contactAttributeName));
        } else if (!"imapUid".equals(contactAttributeName)) {
            if (this.mode == 130 || this.mode == 129) {
                LogUtils.debug((Logger)log, (Object[])new Object[]{"getContactSearchFilter: contains", this.value});
                condition = this.conditions.contains(contactAttributeName, this.value);
            } else {
                LogUtils.debug((Logger)log, (Object[])new Object[]{"getContactSearchFilter: startswith", this.value});
                condition = this.conditions.startsWith(contactAttributeName, this.value);
            }
        }
        return condition;
    }

    @Override
    public boolean isMatch(LdapContact person) throws NotAuthorizedException, BadRequestException {
        if (this.canIgnore) {
            return true;
        }
        String propValue = this.propertyMapper.getLdapPropertyValue(this.attributeName, (Resource)person);
        if (propValue == null) {
            return false;
        }
        if (propValue == null) {
            return true;
        }
        if (this.operator == 163 && propValue.equalsIgnoreCase(this.value)) {
            return true;
        }
        return this.operator == 164 && propValue.toLowerCase().indexOf(this.value.toLowerCase()) >= 0;
    }

    @Override
    public List<LdapContact> findInGAL(LdapPrincipal user, Set<String> returningAttributes, int sizeLimit) throws IOException, NotAuthorizedException, BadRequestException {
        if (this.canIgnore) {
            return null;
        }
        String contactAttributeName = this.attributeName;
        if (contactAttributeName != null) {
            List<LdapContact> galPersons = this.userFactory.galFind(this.conditions.startsWith(contactAttributeName, STAR.equals(this.value) ? "A" : this.value), sizeLimit);
            if (this.operator == 163) {
                ArrayList<LdapContact> list = new ArrayList<LdapContact>();
                for (LdapContact person : galPersons) {
                    if (!this.isMatch(person)) continue;
                    list.add(person);
                }
                return list;
            }
            return galPersons;
        }
        return null;
    }

    @Override
    public void add(LdapFilter filter) {
        log.error("LOG_LDAP_UNSUPPORTED_FILTER", (Object)"nested simple filters");
    }
}

